package com.biz.crm.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.contract.ContractUtil;
import com.biz.crm.contract.entity.ContractEntity;
import com.biz.crm.contract.entity.ContractSalesAreaEntity;
import com.biz.crm.contract.mapper.ContractSalesAreaMapper;
import com.biz.crm.contract.service.ContractSalesAreaService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.dms.contract.ContractSalesAreaVo;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: heyijiang
 * @Date: 2020/11/4 10:52
 */
@ConditionalOnMissingBean(name = "contractSalesAreaServiceExpandImpl")
@Service(value = "contractSalesAreaService")
public class ContractSalesAreaServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<ContractSalesAreaMapper, ContractSalesAreaEntity> implements ContractSalesAreaService {

    @Resource
    private ContractSalesAreaMapper contractSalesAreaMapper;

    /**
     * 1、验证
     * 2、删除合同下所有文件
     * 3、组装
     * 4、保存
     * @param contractEntity
     * @param salesAreas
     */
    @Override
    @Transactional
    public void replace(ContractEntity contractEntity, List<ContractSalesAreaVo> salesAreas,List<ContractSalesAreaVo> salesAreasNoContain) {
        //1
        //合并
        if(CollectionUtils.isEmpty(salesAreas)){
            salesAreas = new ArrayList<>();
        }
        //包含区域去重
        ContractUtil.checkRepeat(salesAreas);
        //非包含区域去重
        ContractUtil.checkRepeat(salesAreasNoContain);
        if(CollectionUtils.isEmpty(salesAreasNoContain)){
            salesAreasNoContain = new ArrayList<>();
        }
        salesAreas.addAll(salesAreasNoContain);
        if(CollectionUtils.isEmpty(salesAreas)){
            return ;
        }

        //2
        this.removeByMap(new HashMap<String, Object>(){{
            put("contract_id", contractEntity.getId());
        }});

        //3
        List<ContractSalesAreaEntity> entities = new ArrayList<>(salesAreas.size());
        for(ContractSalesAreaVo vo : salesAreas){
            ContractSalesAreaEntity entity = new ContractSalesAreaEntity();
            BeanUtils.copyProperties(vo, entity);
            entity.setContractId(contractEntity.getId());
            entities.add(entity);
        }

        //4
        this.saveBatch(entities);
    }



    /**
     * 1、验证
     * 2、查询并且组装返回
     * @param contractId
     * @return
     */
    @Override
    public Map<String,List<ContractSalesAreaVo>> findByContractId(String contractId) {
        Map<String,List<ContractSalesAreaVo>> reMap = new HashMap<>();
        List<ContractSalesAreaVo> containList = new ArrayList<>();
        List<ContractSalesAreaVo> noContainList = new ArrayList<>();
        reMap.put("contain",containList);
        reMap.put("noContain",noContainList);
        //1
        if(StringUtils.isEmpty(contractId)){
            return reMap;
        }

        //2
        QueryWrapper<ContractSalesAreaEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", contractId);
        List<ContractSalesAreaEntity> salesAreaEntities =  contractSalesAreaMapper.selectList(wrapper);
        if(CollectionUtils.isEmpty(salesAreaEntities)){
            return reMap;
        }
        for(ContractSalesAreaEntity entity : salesAreaEntities){
            ContractSalesAreaVo salesAreaVo = new ContractSalesAreaVo();
            BeanUtils.copyProperties(entity, salesAreaVo);
            if(null != entity.getContainFlag()
                    && entity.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue()){
                containList.add(salesAreaVo);
            }else {
                noContainList.add(salesAreaVo);
            }
        }
        return reMap;
    }

    @Override
    @Transactional
    public void delByContractIds(List<String> contractIds) {
        if(CollectionUtils.isEmpty(contractIds)){
            throw new BusinessException("合同id为空");
        }
        QueryWrapper<ContractSalesAreaEntity> wrapper = new QueryWrapper<>();
        wrapper.in("contract_id", contractIds);
        contractSalesAreaMapper.delete(wrapper);
    }
}
