package com.biz.crm.contractdetails.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.nebular.dms.contractdetails.ContractDetailsVo;
import com.biz.crm.contractdetails.service.ContractDetailsService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author HP
 * @title: SaleContractDetailsController
 * @projectName crm
 * @description: TODO
 * @date 2021/2/209:42
 */
@Api(value = "管理端-合同细则接口", tags = "管理端-合同细则接口")
@RestController
@RequestMapping(value = "/m/saleContractDetails")
public class SaleContractDetailsController {

    @Resource
    private ContractDetailsService contractDetailsService;

    @CrmLog
    @ApiOperation(value = "新增合同细则")
    @PostMapping("addContractDetails")
    public Result<ContractDetailsVo> addContractDetails(@RequestBody ContractDetailsVo contractDetailsVo) {
        ContractDetailsVo result = this.contractDetailsService.add(contractDetailsVo);
        return Result.ok(result);
    }

    @CrmLog
    @ApiOperation(value = "查询合同细则")
    @PostMapping("selectContractDetails")
    public Result<ContractDetailsVo> selectContractDetails(@RequestBody ContractDetailsVo contractDetailsVo) {
        ContractDetailsVo result = this.contractDetailsService.findByContractCode(contractDetailsVo);
        return Result.ok(result);
    }

    @CrmLog
    @ApiOperation(value = "修改合同细则")
    @PostMapping("updateContractDetails")
    public Result<ContractDetailsVo> updateContractDetails(@RequestBody ContractDetailsVo contractDetailsVo) {
        ContractDetailsVo result = this.contractDetailsService.edit(contractDetailsVo);
        return Result.ok(result);
    }
}
