package com.biz.crm.contractupdatingfiles.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.nebular.dms.contractupdatingfiles.ContractUpdatingFilesVo;
import com.biz.crm.contractupdatingfiles.service.ContractUpdatingFilesService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author HP
 * @title: ContractUpdatingFilesController
 * @projectName crm
 * @description: TODO
 * @date 2021/2/2010:44
 */
@Api(value = "管理端-合同附件上传接口", tags = "管理端-合同附件上传接口")
@RestController
@RequestMapping(value = "/m/saleContractUpdatingFiles")
public class ContractUpdatingFilesController {
    @Resource
    private ContractUpdatingFilesService contractUpdatingFilesService;

    @CrmLog
    @ApiOperation(value = "合同附件上传")
    @PostMapping("contractUpdatingFilesAdd")
    public Result<ContractUpdatingFilesVo> updatingFilesAdd(@RequestBody ContractUpdatingFilesVo contractUpdatingFilesVo) {
        ContractUpdatingFilesVo result = this.contractUpdatingFilesService.add(contractUpdatingFilesVo);
        return Result.ok(result);
    }

    @CrmLog
    @ApiOperation(value = "合同附件编辑")
    @PostMapping("contractUpdatingFilesEdit")
    public Result<ContractUpdatingFilesVo> updatingFilesEdit(@RequestBody ContractUpdatingFilesVo contractUpdatingFilesVo) {
        ContractUpdatingFilesVo result = this.contractUpdatingFilesService.edit(contractUpdatingFilesVo);
        return Result.ok(result);
    }
}
