package com.biz.crm.contractupdatingfiles.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;



import javax.persistence.Index;


/**
 * @author HP
 * @title: 合同附件实体类
 * @projectName crm
 * @description: TODO
 * @date 2021/2/2010:43
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_sale_contract_updating_files")
@CrmTable(name = "dms_sale_contract_updating_files", indexes = {
        @Index(name = "sale_contract_updating_code", columnList = "sale_contract_code")
})
public class ContractUpdatingFilesEntity extends CrmExtTenEntity {
    /**
     * 合同编码   货补费用池明细条目审批详情日志
     */
    @CrmColumn(name = "sale_contract_code", length = 64)
    private String saleContractCode;
    /**
     * 文件名
     */
    @CrmColumn(name = "file_name", length = 100)
    private String fileName;

    /**
     * 文件唯一标识
     */
    @CrmColumn(name = "object_name", length = 100)
    private String objectName;

    /**
     * 文件全路径
     */
    @CrmColumn(name = "url", length = 200)
    private String url;

    /**
     * 文件路径
     */
    @CrmColumn(name = "url_path", length = 200)
    private String urlPath;

    /**
     * 域名
     */
    @CrmColumn(name = "url_path_prefix", length = 100)
    private String urlPathPrefix;
}
