package com.biz.crm.contractupdatingfiles.service.Impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.dms.contractupdatingfiles.ContractUpdatingFilesVo;
import com.biz.crm.contractupdatingfiles.entity.ContractUpdatingFilesEntity;
import com.biz.crm.contractupdatingfiles.mapper.ContractUpdatingFilesMapper;
import com.biz.crm.contractupdatingfiles.service.ContractUpdatingFilesService;
import com.biz.crm.salecontract.entity.ContractTemplateTupleMappingEntity;
import com.biz.crm.salecontract.mapper.ContractTemplateTupleMappingMapper;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author HP
 * @title: ContractUpdatingFilesServiceImpl
 * @projectName crm
 * @description: TODO
 * @date 2021/2/2010:50
 */
@ConditionalOnMissingBean(name = "contractUpdatingFilesServiceImpl")
@Service(value = "contractUpdatingFilesService")
public class ContractUpdatingFilesServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<ContractUpdatingFilesMapper, ContractUpdatingFilesEntity> implements ContractUpdatingFilesService {

    @Resource
    private ContractUpdatingFilesMapper contractUpdatingFilesMapper;
    @Override
    public ContractUpdatingFilesVo add(ContractUpdatingFilesVo contractUpdatingFilesVo) {
        //校验入参
        ValidateUtils.validate(contractUpdatingFilesVo.getSaleContractCode(), "合同编码不能为空");
        ValidateUtils.validate(contractUpdatingFilesVo.getFileName(), "文件名不能为空");
        ValidateUtils.validate(contractUpdatingFilesVo.getObjectName(), "文件唯一标识不能为空");
        ValidateUtils.validate(contractUpdatingFilesVo.getUrl(), "文件全路径不能为空");
        ValidateUtils.validate(contractUpdatingFilesVo.getUrlPath(), "文件路径不能为空");
        ValidateUtils.validate(contractUpdatingFilesVo.getUrlPathPrefix(), "域名不能为空");
        //校验合同编码是否存在
        ContractUpdatingFilesEntity contractDetailsEntity = contractUpdatingFilesMapper.selectOne(Wrappers.<ContractUpdatingFilesEntity>query().eq("sale_contract_code", contractUpdatingFilesVo.getSaleContractCode()));
        if(contractDetailsEntity!=null){
            Boolean f = false;
            ValidateUtils.isTrue(f, "合同编码已存在");
        }
        //保存合同附件
        ContractUpdatingFilesEntity contractUpdatingFilesEntity = CrmBeanUtil.copy(contractUpdatingFilesVo,ContractUpdatingFilesEntity.class);
//        boolean addResult = this.save(contractUpdatingFilesEntity);
        int rtn = contractUpdatingFilesMapper.insert(contractUpdatingFilesEntity);
        if(rtn!=1){
            Boolean f = false;
            ValidateUtils.isTrue(f, "新增合同附件失败");
        }
        return contractUpdatingFilesVo;
    }

    @Override
    public List<ContractUpdatingFilesVo> findByContractCode(String contractCode) {
        if(StringUtils.isEmpty(contractCode)) {
            return Lists.newArrayList();
        }
        List<ContractUpdatingFilesEntity> contractUpdatingFilesEntity = contractUpdatingFilesMapper.selectList(Wrappers.<ContractUpdatingFilesEntity>query().eq("sale_contract_code", contractCode));
        List<ContractUpdatingFilesVo> contractUpdatingFilesVos = CrmBeanUtil.copyList(contractUpdatingFilesEntity,ContractUpdatingFilesVo.class);

        return contractUpdatingFilesVos;
    }

    @Override
    public ContractUpdatingFilesVo edit(ContractUpdatingFilesVo contractUpdatingFilesVo) {
        //校验入参
        ValidateUtils.validate(contractUpdatingFilesVo.getSaleContractCode(), "合同编码不能为空");
        ValidateUtils.validate(contractUpdatingFilesVo.getFileName(), "文件名不能为空");
        ValidateUtils.validate(contractUpdatingFilesVo.getObjectName(), "文件唯一标识不能为空");
        ValidateUtils.validate(contractUpdatingFilesVo.getUrl(), "文件全路径不能为空");
        ValidateUtils.validate(contractUpdatingFilesVo.getUrlPath(), "文件路径不能为空");
        ValidateUtils.validate(contractUpdatingFilesVo.getUrlPathPrefix(), "域名不能为空");
        //校验合同编码是否存在
        ContractUpdatingFilesEntity entity = contractUpdatingFilesMapper.selectOne(Wrappers.<ContractUpdatingFilesEntity>query().eq("sale_contract_code", contractUpdatingFilesVo.getSaleContractCode()));
        if(entity==null){
            Boolean f = false;
            ValidateUtils.isTrue(f, "合同编码不存在");
        }
        //保存修改
        ContractUpdatingFilesEntity contractUpdatingFilesEntitydb = CrmBeanUtil.copy(contractUpdatingFilesVo,ContractUpdatingFilesEntity.class);
        contractUpdatingFilesMapper.update(contractUpdatingFilesEntitydb,Wrappers.<ContractUpdatingFilesEntity>query().eq("sale_contract_code", contractUpdatingFilesVo.getSaleContractCode()));
        return contractUpdatingFilesVo;
    }

    /**
     * 批量更新文件
     * 1、校验入参
     * 2、删除老数据
     * 3、新增新数据
     * @param filesVos
     * @param contractCode
     * @return
     */
    @Override
    public List<ContractUpdatingFilesVo> replace(List<ContractUpdatingFilesVo> filesVos, String contractCode) {
        //1、
        ValidateUtils.validate(filesVos, "文件列表不能为空");
        ValidateUtils.validate(contractCode, "合同编码不能为空");
        //2、
        QueryWrapper wrapper = Wrappers.query().eq("sale_contract_code", contractCode);
        this.contractUpdatingFilesMapper.delete(wrapper);
        //3、
        filesVos.forEach(file -> file.setSaleContractCode(contractCode));
        List<ContractUpdatingFilesEntity> entities = CrmBeanUtil.copyList(filesVos, ContractUpdatingFilesEntity.class);
        boolean addResult = this.saveOrUpdateBatch(entities);
        ValidateUtils.validate(addResult, "批量新增文件失败");
        return CrmBeanUtil.copyList(entities, ContractUpdatingFilesVo.class);
    }
}
