package com.biz.crm.liabilityforbreach.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;



import javax.persistence.Index;


/**
 * 违约责任实体
 * @author liufan E-mail:fan.liu@biz-united.com.cn
 * @version 创建时间：2021/2/20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_liability_for_breach")
@CrmTable(name = "dms_liability_for_breach", indexes = {
        @Index(name = "index_liability_for_breach_code", columnList = "sale_contract_code")
},tableNote = "违约责任实体")
public class LiabilityForBreachEntity extends CrmExtTenEntity {
    /**
     * 合同编码
     */
    @CrmColumn(name = "sale_contract_code", length = 64)
    private String saleContractCode;
    /**
     * 违约责任
     */
    @CrmColumn(name = "liability_for_breach", length = 4000)
    private String LiabilityForBreach;
}
