package com.biz.crm.liabilityforbreach.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.liabilityforbreach.entity.LiabilityForBreachEntity;
import com.biz.crm.liabilityforbreach.mapper.LiabilityForBreachMapper;
import com.biz.crm.liabilityforbreach.service.LiabilityForBreachService;
import com.biz.crm.nebular.dms.liablityforbreache.LiabilityForBreachVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.ValidateUtils;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 违约责任逻辑处理实现类
 * @author liufan E-mail:fan.liu@biz-united.com.cn
 * @version 创建时间：2021/2/20
 */
@Service("liabilityForBreachService")
@ConditionalOnMissingBean(name = "liabilityForBreachServiceImpl")
public class LiabilityForBreachServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<LiabilityForBreachMapper, LiabilityForBreachEntity> implements LiabilityForBreachService {

    @Resource
    private LiabilityForBreachMapper liabilityMapper;
    /**
     * 将违约责任进行保存
     * 1、入参校验
     * 2、获取参数
     * 3、进行保存
     * @param vos 合同号，违约责任
     * @return 保存结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<LiabilityForBreachVo> replace(List<LiabilityForBreachVo> vos, String contractCode) {
        //入参校验
        this.validateReplace(vos);
        vos.forEach(vo -> vo.setSaleContractCode(contractCode));
        //获取参数
        List<LiabilityForBreachEntity> entities = CrmBeanUtil.copyList(vos, LiabilityForBreachEntity.class);
        //清空之前的对应
        liabilityMapper.delete(new QueryWrapper<LiabilityForBreachEntity>().eq("sale_contract_code", contractCode));
        //保存
        boolean addResult = this.saveBatch(entities);
        ValidateUtils.isTrue(addResult, "操作失败");
        return CrmBeanUtil.copyList(entities, LiabilityForBreachVo.class);
    }

    @Override
    public LiabilityForBreachVo findLiabilityBySaleContractCode(String saleContractCode) {
        //校验入参,合同编码不能为空
        ValidateUtils.validate(saleContractCode, "合同id不能为空");
        //进行查询
        LiabilityForBreachEntity goodsEntity = liabilityMapper.selectOne(
                new QueryWrapper<LiabilityForBreachEntity>().eq("sale_contract_code", saleContractCode));
        //包装vo
        LiabilityForBreachVo vo = CrmBeanUtil.copy(goodsEntity, LiabilityForBreachVo.class);
        return vo;
    }

    /**
     * 校验入参
     * @param vos
     */
    private void validateReplace(List<LiabilityForBreachVo> vos) {
        ValidateUtils.notEmpty(vos, "上传参数不能为空");
    }
}
