package com.biz.crm.minbuynumofproduct.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.minbuynumofproduct.service.MinBuyNumOfProductService;
import com.biz.crm.nebular.dms.minbuynumofproduct.MinBuyNumOfProductVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;

/**
 * @Author: huojia
 * @DateTime: 2021/1/25 16:27
 **/
@Api(value = "管理端-起订量", tags = "管理端-起订量")
@RestController
@RequestMapping("/m/minBuyNumOfProduct")
public class MinBuyNumOfProductmController {

    @Resource
    private MinBuyNumOfProductService minBuyNumOfProductService;

    @CrmLog
    @ApiOperation(value = "批量新增")
    @PostMapping(value = "add")
    public Result add(@RequestBody ArrayList<MinBuyNumOfProductVo> minBuyNumOfProductVos) {
        minBuyNumOfProductService.add(minBuyNumOfProductVos);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "分页搜索")
    @PostMapping(value = "list")
    public Result<PageResult<MinBuyNumOfProductVo>> list(@RequestBody MinBuyNumOfProductVo minBuyNumOfProductVo) {
        return Result.ok(minBuyNumOfProductService.list(minBuyNumOfProductVo));
    }

    @CrmLog
    @ApiOperation(value = "批量启用")
    @PostMapping(value = "valid")
    public Result valid(@RequestBody ArrayList<String> ids) {
        minBuyNumOfProductService.updateEffectiveFlag(ids, YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "批量禁用")
    @PostMapping(value = "invalid")
    public Result invalid(@RequestBody ArrayList<String> ids) {
        minBuyNumOfProductService.updateEffectiveFlag(ids, YesNoEnum.YesNoCodeNumberEnum.NO.getCode());
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "修改")
    @PostMapping(value = "update")
    public Result update(@RequestBody MinBuyNumOfProductVo minBuyNumOfProductVo) {
        minBuyNumOfProductService.update(minBuyNumOfProductVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "批量删除")
    @PostMapping(value = "delByIds")
    public Result delByIds(@RequestBody ArrayList<String> ids) {
        minBuyNumOfProductService.delByIds(ids);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "通过客户及其组织查询产品的最小起订量")
    @PostMapping(value = "findByCusCodeAndProductCodesToCus")
    public Result findByCusCodeAndProductCodesToCus(String cusCode, String orgCode, @RequestBody ArrayList<String> productCodes) {
        Map<String, MinBuyNumOfProductVo> result = minBuyNumOfProductService.findByCusCodeAndProductCodesToCus(cusCode, orgCode, productCodes);
        return Result.ok(result);
    }
}