package com.biz.crm.minbuynumofproduct.entity;

import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.util.MinBuyNumOfProductConstant;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.elasticsearch.annotations.Document;

import java.math.BigDecimal;

/**
 * 起订量实体类
 *
 * @Author: huojia
 * @DateTime: 2021/1/25 16:25
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@Document(indexName = MinBuyNumOfProductConstant.ES_MIN_BUY_NUM_OF_PRODUCT_INDEX_NAME, type = MinBuyNumOfProductConstant.ES_MIN_BUY_NUM_OF_PRODUCT_TYPE, createIndex = false)
public class MinBuyNumOfProductEntity extends CrmExtEntity {

    /**
     * 产品编码
     */
    private String productCode;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 维度类型（数据字典）
     */
    private String dimensionType;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 组织编码
     */
    private String orgCode;

    /**
     * 客户名称
     */
    private String cusName;

    /**
     * 客户编码
     */
    private String cusCode;

    /**
     * 终端名称
     */
    private String terminalName;

    /**
     * 终端编码
     */
    private String terminalCode;

    /**
     * 校验方式（dms_minOrder_verificationMode）
     */
    private String verificationMode;

    /**
     * 单位名称
     */
    private String unitName;

    /**
     * 单位编码
     */
    private String unitCode;

    /**
     * 起订量
     */
    private BigDecimal minOrderQuantity;

    /**
     * 启禁状态
     */
    private Integer effectiveFlag;

    /**
     * 新增判重时使用的onlyKey（产品+组织/客户/终端）
     */
    private String onlyKey;
}