package com.biz.crm.minbuynumofproduct.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.minbuynumofproduct.entity.MinBuyNumOfProductEntity;
import com.biz.crm.nebular.dms.minbuynumofproduct.MinBuyNumOfProductVo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Author: huojia
 * @DateTime: 2021/1/25 16:29
 **/
public interface MinBuyNumOfProductService {

    /**
     * 新增最小起订量
     *
     * @param minOrderVos
     * @author: huojia
     * @date: 2021/1/25 17:11
     * @return: void
     */
    void add(ArrayList<MinBuyNumOfProductVo> minOrderVos);

    /**
     * 分页搜索起订量
     *
     * @param minOrderVo
     * @author: huojia
     * @date: 2021/1/25 20:14
     * @return: java.lang.String
     */
    PageResult<MinBuyNumOfProductVo> list(MinBuyNumOfProductVo minOrderVo);

    /**
     * 根据id批量修改有效状态
     *
     * @param ids
     * @param code
     * @author: huojia
     * @date: 2021/1/26 14:03
     * @return: void
     */
    void updateEffectiveFlag(ArrayList<String> ids, Integer code);

    /**
     * 修改
     *
     * @param minOrderVo
     * @author: huojia
     * @date: 2021/1/26 14:54
     * @return: void
     */
    void update(MinBuyNumOfProductVo minOrderVo);

    /**
     * 根据id批量删除
     * @param ids
     * @author: huojia
     * @date: 2021/1/26 15:16
     * @return: void
     */
    void delByIds(ArrayList<String> ids);


    /**
     * 通过客户及其组织查询产品的最小起订量
     * @param cusCode 客户编码
     * @param orgCode 客户组织编码
     * @param productCodes 产品
     * @return 启用的,
     */
    Map<String, MinBuyNumOfProductVo> findByCusCodeAndProductCodesToCus(String cusCode, String orgCode, List<String> productCodes);
}
