package com.biz.crm.notice.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.minbuynumofproduct.entity.MinBuyNumOfProductEntity;
import com.biz.crm.nebular.dms.minbuynumofproduct.MinBuyNumOfProductVo;
import com.biz.crm.nebular.dms.notice.NoticeVo;
import com.biz.crm.notice.service.NoticeService;
import com.biz.crm.promotion.service.npromotion.validators.PromotionValidator;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/8 17:37
 **/
@Api(value = "管理端-公告", tags = "管理端-公告")
@RestController
@RequestMapping("/m/notice")
public class NoticemController {

    @Resource
    private NoticeService noticeService;


    @CrmLog
    @ApiOperation(value = "新增")
    @PostMapping(value = "add")
    public Result add(@RequestBody NoticeVo noticeVo) {
        noticeService.add(noticeVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "编辑")
    @PostMapping(value = "edit")
    public Result edit(@RequestBody NoticeVo noticeVo) {
        noticeService.edit(noticeVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "通过id查询")
    @GetMapping(value = "findById/{id}")
    public Result<NoticeVo> findById(@PathVariable("id") String id) {
        return Result.ok(noticeService.findById(id));
    }

    @CrmLog
    @ApiOperation(value = "分页搜索公告")
    @PostMapping(value = "list")
    public Result<PageResult<NoticeVo>> list(@RequestBody NoticeVo noticeVo) {
        return Result.ok(noticeService.list(noticeVo));
    }


    @ApiOperation(value = "根据id批量删除")
    @PostMapping(value = "delByIds")
    public Result<Object> delByIds(@RequestBody ArrayList<String> ids) {
        noticeService.delByIds(ids);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "根据查询条件批量删除")
    @PostMapping(value = "delByParam")
    public Result<Object> delByParam(@RequestBody NoticeVo noticeVo) {
        noticeService.delByParam(noticeVo);
        return Result.ok();
    }
}
