package com.biz.crm.notice.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.notice.ListReq;
import com.biz.crm.nebular.dms.notice.ListRes;
import com.biz.crm.nebular.dms.notice.NoticeVisitedLogVo;
import com.biz.crm.nebular.dms.notice.NoticeVo;
import com.biz.crm.notice.service.NoticeService;
import com.biz.crm.notice.service.NoticeVisitedLogService;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

@Api(value = "PC端-公告", tags = "PC端-公告")
@RestController
@RequestMapping(value = "/p/notice")
public class NoticepController {

    @Resource
    private NoticeService noticeService;
    @Resource
    private NoticeVisitedLogService noticeVisitedLogService;

    @CrmLog
    @CrossOrigin
    @ApiOperation(value = "分页展示公告")
    @PostMapping(value = "list")
    public Result<PageResult<ListRes>> list(@RequestBody ListReq listReq){
        UserRedis userRedis = UserUtils.getUser();
        listReq.setCusCode(userRedis.getCustcode());
        return Result.ok(noticeService.listByUser(listReq,UserUtils.handleOrgCodes(userRedis.getOrgcode())));
    }

    @CrmLog
    @CrossOrigin
    @ApiOperation(value = "阅读公告")
    @PostMapping(value = "readNotice")
    public Result readNotice(@RequestBody NoticeVisitedLogVo noticeVisitedLogVo){
        UserRedis userRedis = UserUtils.getUser();
        noticeVisitedLogVo.setCusCode(userRedis.getCustcode());
        noticeVisitedLogVo.setCusName(userRedis.getCustname());
        noticeVisitedLogService.readNotice(noticeVisitedLogVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "通过id查询")
    @GetMapping(value = "findById/{id}")
    public Result<NoticeVo> findById(@PathVariable("id") String id) {
        return Result.ok(noticeService.findById(id));
    }
}
