package com.biz.crm.notice.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.dms.notice.ListReq;
import com.biz.crm.nebular.dms.notice.ListRes;
import com.biz.crm.nebular.dms.notice.NoticeVo;
import com.biz.crm.notice.entity.NoticeEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/11 16:40
 **/
public interface NoticeMapper extends BaseMapper<NoticeEntity> {

    /**
     * 分页搜索
     * @param page
     * @return
     */
    List<NoticeVo> list(Page page, @Param("ew") QueryWrapper<NoticeVo> wrapper);

    /**
     * 分页搜索(前段)
     * @param page
     * @param listReq
     * @param now
     * @param orgCodes
     * @return
     */
    List<ListRes> listByUser(Page page, @Param("listReq") ListReq listReq, @Param("now") String now,
                             @Param("offsetFlag") Integer offsetFlag, @Param("containFlag") Integer containFlag,
                             @Param("nonContainFlag") Integer nonContainFlag, @Param("orgCodes") List<String> orgCodes);
}
