package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.nebular.dms.notice.NoticeVisitedLogVo;
import com.biz.crm.notice.entity.NoticeVisitedLogEntity;
import com.biz.crm.notice.mapper.NoticeVisitedLogMapper;
import com.biz.crm.notice.service.NoticeService;
import com.biz.crm.notice.service.NoticeVisitedLogService;
import com.biz.crm.util.DmsConstant;
import com.biz.crm.util.ValidateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

@ConditionalOnMissingBean(name = "noticeVisitedLogServiceExpandImpl")
@Service(value = "noticeVisitedLogService")
public class NoticeVisitedLogServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<NoticeVisitedLogMapper, NoticeVisitedLogEntity>
        implements NoticeVisitedLogService {

    @Resource
    private NoticeService noticeService;
    @Resource
    private NoticeVisitedLogMapper noticeVisitedLogMapper;

    /**
     * 1、验证
     * 2、查看经销商是否阅读过该公告
     * 3、如果阅读过，返回；反之则添加阅读记录
     * 4、对应公告阅读数+1
     * @param noticeVisitedLogVo
     */
    @Override
    @Klock(keys = {DmsConstant.NOTICE_LOG_LOCK ,"#noticeVisitedLogVo.cusCode"},waitTime = 20,leaseTime = 5)
    @Transactional
    public void readNotice(NoticeVisitedLogVo noticeVisitedLogVo) {
        //1
        ValidateUtils.validate(noticeVisitedLogVo.getNoticeId(),"请指定查询的公告");

        //2
        QueryWrapper<NoticeVisitedLogEntity> wrapper = new QueryWrapper();
        wrapper.eq("notice_id", noticeVisitedLogVo.getNoticeId());
        wrapper.eq("cus_code", noticeVisitedLogVo.getCusCode());
        NoticeVisitedLogEntity entity = noticeVisitedLogMapper.selectOne(wrapper);

        //3
        if(null != entity){
            return;
        }
        entity = new NoticeVisitedLogEntity();
        BeanUtils.copyProperties(noticeVisitedLogVo, entity);
        noticeVisitedLogMapper.insert(entity);

        //4
        noticeService.updateVisitNum(noticeVisitedLogVo.getNoticeId());

    }
}
