package com.biz.crm.order.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;


/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/1/27 16:49
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_order_detail_promotion")
@CrmTable(name = "dms_order_detail_promotion",tableNote = "订单对应促销信息")
public class OrderDetailPromotionEntity extends CrmBaseEntity<OrderDetailPromotionEntity> {

    /**
     * 订单编码
     */
    @CrmColumn(name = "order_code", length = 64)
    private String orderCode;

    /**
     * 订单行号
     */
    @CrmColumn(name = "order_detail_line_no", length = 64)
    private String orderDetailLineNo;

    /**
     * 促销code
     */
    @CrmColumn(name = "promotion_code", length = 64)
    private String promotionCode;

    /**
     * 促销名称
     */
    @CrmColumn(name = "promotion_name", length = 100)
    private String promotionName;

}
