package com.biz.crm.order.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.order.entity.OrderDetailEntity;
import com.biz.crm.order.entity.OrderEntity;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/1/28 16:47
 **/
public interface OrderDetailService extends IService<OrderDetailEntity> {

    /**
     * 批量保存订单详情
     * @param orderVo
     * @param orderEntity
     * @param removeZreoFlag 是否去掉数量为0的行
     * @return
     */
    List<OrderDetailEntity> addBatch(OrderVo orderVo, OrderEntity orderEntity,boolean removeZreoFlag);

    /**
     * 批量保存订单详情
     * @param orderVo
     * @param orderEntity
     */
    List<OrderDetailEntity> editBatch(OrderVo orderVo, OrderEntity orderEntity,boolean removeZreoFlag);

    /**
     * 根据订单号删除行
     * @param orderCode
     */
    void deleteByOrderCode(String orderCode);

  /**
   * 根据订单编码查询分组后的订单详情
   * @param orderCode 订单编码
   * @return
   */
    List<OrderGroupItemVo> findGroupByOrderCode(String orderCode);

  /**
   * 根据订单编码查询所有订单详情
   * @param orderCode 订单编码
   * @return
   */
    List<OrderDetailVo> findByOrderCode(String orderCode);

    /**
     * 根据订单编码列表删除订单明细
     * @param orderCodes
     */
    void deleteByOrderCodes(List<String> orderCodes);
}
