package com.biz.crm.order.tools.handler;

import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 计算订单中行价格问题
 * @Author: zhangyuzhu
 * @Date: 2021/3/17 11:35
 **/
@ConditionalOnMissingBean(name = "orderCalPriceHandlerExpand")
@Component("orderCalPriceHandler")
public class OrderCalPriceHandler {

    /**
     * 处理
     * @param orderVo
     * @return
     */
    public OrderVo cal(OrderVo orderVo){
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            this.calItemPrice(orderVo,groupItemVo);
        }
        return orderVo;
    }

    /**
     * 计算行价格
     * @param orderVo
     * @param groupItemVo
     */
    public void calItemPrice(OrderVo orderVo,OrderGroupItemVo groupItemVo){
        if(!CollectionUtils.isEmpty(groupItemVo.getBackList())){
            for(OrderDetailVo item : groupItemVo.getBackList()){
                item.setAmount(item.getPrice().multiply(
                        item.getProductNum()
                ).setScale(6, BigDecimal.ROUND_HALF_UP));
            }
        }

        if(!CollectionUtils.isEmpty(groupItemVo.getGiftList())){
            List<OrderDetailVo> giftList = new ArrayList<>();
            for(OrderDetailVo item : groupItemVo.getGiftList()){
                item.setAmount(item.getPrice().multiply(
                        item.getProductNum()
                ).setScale(6,BigDecimal.ROUND_HALF_UP));
            }
        }

        if(!CollectionUtils.isEmpty(groupItemVo.getNormalList())){
            List<OrderDetailVo> normalList = new ArrayList<>();
            for(OrderDetailVo item : groupItemVo.getNormalList()){
                item.setAmount(item.getPrice().multiply(
                        item.getProductNum()
                ).setScale(6,BigDecimal.ROUND_HALF_UP));
            }
        }
    }


}
