package com.biz.crm.order.tools.handler;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfoQueryVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.promotion.service.PromotionPolicyService;
import com.biz.crm.util.CommonConstant;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Description: 处理订单中促销算价问题
 * @Author: zhangyuzhu
 * @Date: 2021/3/17 11:35
 **/
@ConditionalOnMissingBean(name = "orderPromotionHandlerExpand")
@Component("orderPromotionHandler")
public class OrderPromotionHandler {

    @Resource
    private PromotionPolicyService promotionPolicyService;

    /**
     * 处理
     * @param orderVo
     * @param cusCode
     * @param orgCode
     * @return
     */
    public OrderVo handle(OrderVo orderVo,String cusCode,String orgCode){
        PromotionPolicyConfigInfoQueryVo promotionPolicyConfigInfoQueryVo = this.packagePromotionParm(orderVo,cusCode,orgCode);
        orderVo = this.setZeroPromotionAmountForGroup(orderVo);
        if(null == promotionPolicyConfigInfoQueryVo){
            return orderVo;
        }
        Map<String, List<PromotionPolicyConfigInfo>> promotionMap = promotionPolicyService.loadPromotionPolicyConfigInfoForOrder(promotionPolicyConfigInfoQueryVo);
        return this.calPromotion(orderVo,promotionMap);
    }


    /**
     * 促销算价
     * @param orderVo
     * @param promotionMap
     * @return
     */
    public OrderVo calPromotion(OrderVo orderVo,Map<String, List<PromotionPolicyConfigInfo>> promotionMap){
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            //该组促销优惠金额
            if(CollectionUtils.isEmpty(groupItemVo.getNormalList())){
                continue;
            }
            BigDecimal promotionAmount = BigDecimal.ZERO;
            for(OrderDetailVo item : groupItemVo.getNormalList()){
                if(!StringUtils.isEmpty(item.getPromotionPolicyCode())){
                    PromotionPolicyConfigInfo promotionPolicyConfigInfo = this.findPromotionByCode(
                            promotionMap.get(item.getProductCode()),item.getPromotionPolicyCode()
                    );
                    if(null == promotionPolicyConfigInfo){
                        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                        item.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        StringBuilder stb = new StringBuilder("提示：促销【")
                                .append(item.getPromotionPolicyName())
                                .append("】不可用！");
                        item.setCalSucessMsg(stb.toString());
                        groupItemVo.setGiftList(new ArrayList<>());
                        continue;
                    }
                    //计算结果
                    CalculateRuleResponse calculateRuleResponse = promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getCalculateRuleResponse();
                    if(null == calculateRuleResponse.getResultData()){
                        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                        item.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        StringBuilder stb = new StringBuilder("提示：促销【")
                                .append(item.getPromotionPolicyName())
                                .append("】本品条件不满足！")
                                .append(calculateRuleResponse.getNoLadderMatchMsg());
                        item.setCalSucessMsg(stb.toString());
                        item.setPromotionPolicyCode(StringUtils.EMPTY);
                        item.setPromotionPolicyName(StringUtils.EMPTY);
                        item.setPromotionPolicyId(StringUtils.EMPTY);
                        if(promotionPolicyConfigInfo.getCalculate().getPromotionType()
                                .equals(PromotionPolicyEunm.PromotionTypeEunm.FULLREDUCTION.getCode())){
                            groupItemVo.setGiftList(new ArrayList<>());
                        }
                        continue;
                    }
                    if(promotionPolicyConfigInfo.getCalculate().getPromotionType()
                            .equals(PromotionPolicyEunm.PromotionTypeEunm.FULLREDUCTION.getCode())){
                        item.setPromotionPolicyId(promotionPolicyConfigInfo.getCalculate().getPromotionPolicyId());
                        item.setPromotionType(promotionPolicyConfigInfo.getCalculate().getPromotionType());
                        item.setPromotionResultType(promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getCalculateRuleResponse().getResultDataType());
                        item.setPromotionResultDate(promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getCalculateRuleResponse().getResultData());
                        item.setAmount(item.getAmount()
                                .subtract(calculateRuleResponse.getResultData()).setScale(6,BigDecimal.ROUND_HALF_UP));
                        promotionAmount = promotionAmount.add(calculateRuleResponse.getResultData());
                    }else if(promotionPolicyConfigInfo.getCalculate().getPromotionType()
                            .equals(PromotionPolicyEunm.PromotionTypeEunm.DISCOUNT.getCode())){
                        item.setPromotionPolicyId(promotionPolicyConfigInfo.getCalculate().getPromotionPolicyId());
                        item.setPromotionType(promotionPolicyConfigInfo.getCalculate().getPromotionType());
                        item.setPromotionResultType(promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getCalculateRuleResponse().getResultDataType());
                        item.setPromotionResultDate(promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getCalculateRuleResponse().getResultData());
                        BigDecimal oldAmount = item.getAmount();
                        item.setAmount(item.getAmount()
                                .multiply(calculateRuleResponse.getResultData()).setScale(6,BigDecimal.ROUND_HALF_UP));
                        promotionAmount = promotionAmount.add(
                                oldAmount
                                        .multiply(BigDecimal.ONE.subtract(calculateRuleResponse.getResultData())).setScale(6,BigDecimal.ROUND_HALF_UP)
                        );
                    }else if(promotionPolicyConfigInfo.getCalculate().getPromotionType()
                            .equals(PromotionPolicyEunm.PromotionTypeEunm.SPECIALPRICE.getCode())){
                        item.setPromotionPolicyId(promotionPolicyConfigInfo.getCalculate().getPromotionPolicyId());
                        item.setPromotionType(promotionPolicyConfigInfo.getCalculate().getPromotionType());
                        item.setPromotionResultType(promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getCalculateRuleResponse().getResultDataType());
                        item.setPromotionResultDate(promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getCalculateRuleResponse().getResultData());
                        BigDecimal oldAmount = item.getAmount();
                        item.setAmount(item.getProductNum()
                                .multiply(calculateRuleResponse.getResultData()).setScale(6,BigDecimal.ROUND_HALF_UP));
                        promotionAmount = promotionAmount.add(
                                oldAmount.subtract(item.getAmount())
                        );
                    }else if(promotionPolicyConfigInfo.getCalculate().getPromotionType()
                            .equals(PromotionPolicyEunm.PromotionTypeEunm.BUYGIFT.getCode())){
                        item.setPromotionPolicyId(promotionPolicyConfigInfo.getCalculate().getPromotionPolicyId());
                        item.setPromotionType(promotionPolicyConfigInfo.getCalculate().getPromotionType());
                        item.setPromotionResultType(promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getCalculateRuleResponse().getResultDataType());
                        item.setPromotionResultDate(promotionPolicyConfigInfo.getPromotionPolicyInfoVo().getCalculateRuleResponse().getResultData());
                        if(!this.validateGift(groupItemVo.getGiftList(),promotionPolicyConfigInfo.getProductsGift(),calculateRuleResponse)){
                            orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                            orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                            item.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                            StringBuilder stb = new StringBuilder("提示：促销【")
                                    .append(item.getPromotionPolicyName())
                                    .append("】赠品已改变，请重新选择！")
                                    .append(calculateRuleResponse.getNoLadderMatchMsg());
                            item.setCalSucessMsg(stb.toString());
                            item.setPromotionPolicyCode(StringUtils.EMPTY);
                            item.setPromotionPolicyName(StringUtils.EMPTY);
                            item.setPromotionPolicyId(StringUtils.EMPTY);
                            groupItemVo.setGiftList(new ArrayList<>());
                        }else {
                            if(!CollectionUtils.isEmpty(groupItemVo.getGiftList())){
                                for(OrderDetailVo gift : groupItemVo.getGiftList()){
                                    promotionAmount = promotionAmount.add(
                                            gift.getProductNum()
                                                    .multiply(gift.getPrice()).setScale(6,BigDecimal.ROUND_HALF_UP)
                                    );
                                }
                            }
                        }
                    }
                }
            }
            groupItemVo.setPromotionAmount(promotionAmount);
        }
        return orderVo;
    }

    /**
     * 验证赠品是否发生变化
     * @return
     */
    public boolean validateGift(List<OrderDetailVo> giftList, List<MdmProductRespVo> productsGift, CalculateRuleResponse calculateRuleResponse){
        for(OrderDetailVo item : giftList){
            MdmProductRespVo gift = this.findGiftByProductCode(productsGift,item.getProductCode());
            if(null == gift){
                return false;
            }
            //数量
            if(calculateRuleResponse.getResultDataType().equals(CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.NUMBER.getItemCode())){
                if(item.getProductNum().intValue() != calculateRuleResponse.getResultData().intValue()){
                    return false;
                }
            }else {
                if(item.getAmount().compareTo(calculateRuleResponse.getResultData()) != 0){
                    return false;
                }
            }
        }
        return true;
    }

    /**
     * 查找特定赠品
     * @param productsGift
     * @param productCode
     * @return
     */
    public MdmProductRespVo findGiftByProductCode(List<MdmProductRespVo> productsGift,String productCode){
        if(CollectionUtils.isEmpty(productsGift)){
            return null;
        }
        for(MdmProductRespVo gift : productsGift){
            if(gift.getProductCode().equals(productCode)){
                return gift;
            }
        }
        return null;
    }

    /**
     * 查找促销结果
     * @param promotionPolicyConfigInfos
     * @param promotionCode
     * @return
     */
    public PromotionPolicyConfigInfo findPromotionByCode(List<PromotionPolicyConfigInfo> promotionPolicyConfigInfos,String promotionCode){
        if(CollectionUtils.isEmpty(promotionPolicyConfigInfos)){
            return null;
        }
        for(PromotionPolicyConfigInfo info : promotionPolicyConfigInfos){
            if(info.getPromotionPolicyInfoVo().getPromotionPolicyCode().equals(promotionCode)){
                return info;
            }
        }
        return null;
    }

    /**
     * 将每一组的促销金额置零
     * @param orderVo
     * @return
     */
    public OrderVo setZeroPromotionAmountForGroup(OrderVo orderVo){
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            groupItemVo.setPromotionAmount(BigDecimal.ZERO);
        }
        return orderVo;
    }

    /**
     * 组装促销算价查询的参数
     * @param orderVo
     * @param cusCode
     * @param orgCode
     * @return
     */
    public PromotionPolicyConfigInfoQueryVo packagePromotionParm(OrderVo orderVo,String cusCode,String orgCode){
        PromotionPolicyConfigInfoQueryVo promotionPolicyConfigInfoQueryVo = new PromotionPolicyConfigInfoQueryVo();
        promotionPolicyConfigInfoQueryVo.setCustCode(cusCode);
        promotionPolicyConfigInfoQueryVo.setOrgCode(orgCode);
        List<PromotionPolicyConfigInfoQueryVo.ProductOrderInfo> orderProductInfos = new ArrayList<>();
        promotionPolicyConfigInfoQueryVo.setOrderProductInfos(orderProductInfos);
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            if(CollectionUtils.isEmpty(groupItemVo.getNormalList())){
                continue;
            }
            for(OrderDetailVo item : groupItemVo.getNormalList()){
                if(!StringUtils.isEmpty(item.getPromotionPolicyCode())){
                    PromotionPolicyConfigInfoQueryVo.ProductOrderInfo productOrderInfo = new PromotionPolicyConfigInfoQueryVo.ProductOrderInfo();
                    productOrderInfo.setProductCode(item.getProductCode());
                    productOrderInfo.setProductBuyNo(item.getProductNum());
                    productOrderInfo.setProductBuyAmount(item.getAmount());
                    productOrderInfo.setPromotionPolicyId(item.getPromotionPolicyId());
                    orderProductInfos.add(productOrderInfo);
                }
            }
        }
        if(CollectionUtils.isEmpty(orderProductInfos)){
            return null;
        }
        return promotionPolicyConfigInfoQueryVo;
    }

}
