package com.biz.crm.order.tools.strategy.calorder.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.fee.pool.FeePoolFeign;
import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToCashVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolAmountQueryReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolAmountQueryRespVo;
import com.biz.crm.order.tools.strategy.calorder.CalOrderStrategy;
import com.biz.crm.orderfeerate.service.OrderFeeRateService;
import com.biz.crm.util.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 标准订单算总价策略
 * @Author: zhangyuzhu
 * @Date: 2021/3/16 19:47
 **/
@ConditionalOnMissingBean(name = "standerdCalOrderStrategyExpand")
@Component("standerdCalOrderStrategy")
public class StanderdCalOrderStrategy implements CalOrderStrategy {

    @Autowired
    private FeePoolFeign feePoolFeign;

    @Resource
    private OrderFeeRateService orderFeeRateService;

    @Override
    public OrderVo cal(OrderVo orderVo,String cusCode,String orgCode, Object... objects) {
        FeePoolAmountQueryReqVo feePoolAmountQueryReqVo = this.packageFeeParam(orderVo,cusCode);
        Result<FeePoolAmountQueryRespVo> result = feePoolFeign.queryPoolAmount(feePoolAmountQueryReqVo);
        if(!result.isSuccess()){
            throw new BusinessException("费用服务正在重启，请联系管理员");
        }
        FeePoolAmountQueryRespVo feePoolAmountQueryRespVo = result.getResult();
        BigDecimal normalAndGiftTotalAmount = this.calNormalAndGiftTotalAmount(orderVo);
        BigDecimal maxCashFee = this.calCashFee(cusCode,orgCode,normalAndGiftTotalAmount);

        //折扣费用可使用余额
        BigDecimal ablecashFee = feePoolAmountQueryRespVo.getDiscountUsableAmount() == null ? BigDecimal.ZERO:feePoolAmountQueryRespVo.getDiscountUsableAmount();
        //订单总金额(不包括 促销优惠价格)
        BigDecimal amount = BigDecimal.ZERO;
        //订单促销优惠金额(包含赠品)
        BigDecimal promotionAmount = BigDecimal.ZERO;
        //订单赠品金额
        BigDecimal giftAmount = BigDecimal.ZERO;
        //订单折扣费用最大使用金额
        BigDecimal maxDiscountAmount = BigDecimal.ZERO;
        //订单折扣费用使用金额
        BigDecimal discountAmount = null == orderVo.getDiscountAmount()?BigDecimal.ZERO:orderVo.getDiscountAmount();
        //订单货补费用使用金额
        BigDecimal repAmount = BigDecimal.ZERO;
        //实际支付金额
        BigDecimal actualAmount = BigDecimal.ZERO;
        for(OrderGroupItemVo orderGroupItemVo : orderVo.getGroupItemVos()){
            promotionAmount = promotionAmount.add(orderGroupItemVo.getPromotionAmount());
            if(!CollectionUtils.isEmpty(orderGroupItemVo.getBackList())){
                for(OrderDetailVo item : orderGroupItemVo.getBackList()){
                    repAmount = repAmount.add(item.getAmount());
                    amount = amount.add(item.getAmount());
                }
            }

            if(!CollectionUtils.isEmpty(orderGroupItemVo.getGiftList())){
                for(OrderDetailVo item : orderGroupItemVo.getGiftList()){
                    amount = amount.add(item.getAmount());
                    giftAmount = giftAmount.add(item.getAmount());
                }
            }

            if(!CollectionUtils.isEmpty(orderGroupItemVo.getNormalList())){
                for(OrderDetailVo item : orderGroupItemVo.getNormalList()){
                    amount = amount.add(item.getAmount());
                }
            }
        }
        amount = amount.add(promotionAmount).subtract(giftAmount);
        actualAmount = amount.subtract(promotionAmount)
                .subtract(repAmount);
        maxCashFee = maxCashFee == null ? actualAmount: maxCashFee;
        //限定现金费用额度
        maxCashFee = ablecashFee.compareTo(maxCashFee) > 0?maxCashFee:ablecashFee;
        if(maxCashFee.compareTo(actualAmount) >= 0){
            maxDiscountAmount = actualAmount;
            if(maxDiscountAmount.compareTo(discountAmount) < 0){
                orderVo = this.handleErr(orderVo,maxDiscountAmount);
            }
        }else {
            maxDiscountAmount = maxCashFee;
            if(maxDiscountAmount.compareTo(discountAmount) < 0){
                orderVo = this.handleErr(orderVo,maxDiscountAmount);
            }
        }
        actualAmount = actualAmount.subtract(discountAmount);
        orderVo.setAmount(amount.setScale(2,BigDecimal.ROUND_HALF_UP));
        orderVo.setPromotionAmount(promotionAmount.setScale(2,BigDecimal.ROUND_HALF_UP));
        orderVo.setMaxDiscountAmount(maxDiscountAmount);
        orderVo.setDiscountAmount(discountAmount.setScale(2,BigDecimal.ROUND_HALF_UP));
        orderVo.setRepAmount(repAmount.setScale(2,BigDecimal.ROUND_HALF_UP));
        orderVo.setActualAmount(actualAmount.setScale(2,BigDecimal.ROUND_HALF_UP));
        return orderVo;
    }

    /**
     * 处理错误
     * @param orderVo
     * @return
     */
    public OrderVo handleErr(OrderVo orderVo,BigDecimal maxDiscountAmount){
        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
        orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GLOB.getCode());
        StringBuilder stb = new StringBuilder("提示：折扣费用超额，最大使用额度为【")
                .append(maxDiscountAmount)
                .append("】！");
        orderVo.setCalSucessMsg(stb.toString());
        return orderVo;
    }

    /**
     * 计算订单本品+赠品总金额
     * @param orderVo
     * @return
     */
    public BigDecimal calNormalAndGiftTotalAmount(OrderVo orderVo){
        BigDecimal reNum = BigDecimal.ZERO;
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            if(!CollectionUtils.isEmpty(groupItemVo.getNormalList())){
                for(OrderDetailVo item : groupItemVo.getNormalList()){
                    reNum = reNum.add(item.getAmount());
                }
            }
            if(!CollectionUtils.isEmpty(groupItemVo.getGiftList())){
                for(OrderDetailVo item : groupItemVo.getGiftList()){
                    reNum = reNum.add(item.getAmount());
                }
            }
        }
        return reNum;
    }

    /**
     * 计算订单最大折扣费用使用量
     * @param cusCode
     * @param orgCode
     * @param normalAndGiftTotalAmount
     * @return
     */
    public BigDecimal calCashFee(String cusCode,String orgCode,BigDecimal normalAndGiftTotalAmount){
        OrderFeeRateCalToCashVo orderFeeRateCalToCashVo = new OrderFeeRateCalToCashVo();
        orderFeeRateCalToCashVo.setCusCode(cusCode);
        orderFeeRateCalToCashVo.setOrgCode(orgCode);
        orderFeeRateCalToCashVo.setOrderMoney(normalAndGiftTotalAmount);
        BigDecimal maxCashFee = orderFeeRateService.calToCash(orderFeeRateCalToCashVo);
        return maxCashFee;
    }

    /**
     * 组装费用查询参数
     * @param orderVo
     * @param cusCode
     * @return
     */
    public FeePoolAmountQueryReqVo packageFeeParam(OrderVo orderVo,String cusCode){
        FeePoolAmountQueryReqVo vo = new FeePoolAmountQueryReqVo();
        vo.setCustomerCode(cusCode);
        List<String> poolCodeList = new ArrayList<>();
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            if(!CollectionUtils.isEmpty(groupItemVo.getBackList())){
                for(OrderDetailVo itemVo : groupItemVo.getBackList()){
                    poolCodeList.add(itemVo.getFeeCode());
                }
            }
        }
        vo.setPoolCodeList(poolCodeList);
        return vo;
    }
}
