package com.biz.crm.order.tools.strategy.validaterebate.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.fee.pool.FeePoolFeign;
import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToRepProductVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToRepVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolAmountQueryReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolAmountQueryRespVo;
import com.biz.crm.order.tools.strategy.validaterebate.ValidateRebateFeeStrategy;
import com.biz.crm.orderfeerate.service.OrderFeeRateService;
import com.biz.crm.util.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description: 标准订单验证策略
 * @Author: zhangyuzhu
 * @Date: 2021/3/16 19:20
 **/
@ConditionalOnMissingBean(name = "standerdOrderValidateFeeStategyExpand")
@Component("standerdOrderValidateFeeStategy")
public class StanderdOrderValidateFeeStategy implements ValidateRebateFeeStrategy {

    @Autowired
    private FeePoolFeign feePoolFeign;

    @Resource
    private OrderFeeRateService orderFeeRateService;

    /**
     * 1、从订单费用使用比例验证
     * 2、从费用余额验证
     * @param orderVo
     * @param cusCode
     * @param orgCode
     * @param objects
     * @return
     */
    @Override
    public OrderVo validate(OrderVo orderVo, String cusCode, String orgCode, Object... objects) {
        //1
        BigDecimal normalAndGiftTotalAmount = this.calNormalAndGiftTotalAmount(orderVo);
        orderVo = this.calRep(orderVo,cusCode,orgCode,normalAndGiftTotalAmount);
        if(orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
            return orderVo;
        }

        //2
        FeePoolAmountQueryReqVo feePoolAmountQueryReqVo = this.packageFeeParam(orderVo,cusCode);
        Result<FeePoolAmountQueryRespVo> result =feePoolFeign.queryPoolAmount(feePoolAmountQueryReqVo);
        if(!result.isSuccess()){
            throw new BusinessException("费用服务正在重启，请联系管理员");
        }
        FeePoolAmountQueryRespVo feePoolAmountQueryRespVo = result.getResult();
        orderVo = this.calRapFromFee(orderVo,feePoolAmountQueryRespVo.getPoolUsableAmountMap());
        return orderVo;
    }


    /**
     * 组装费用查询参数
     * @param orderVo
     * @param cusCode
     * @return
     */
    public FeePoolAmountQueryReqVo packageFeeParam(OrderVo orderVo,String cusCode){
        FeePoolAmountQueryReqVo vo = new FeePoolAmountQueryReqVo();
        vo.setCustomerCode(cusCode);
        List<String> poolCodeList = new ArrayList<>();
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            if(!CollectionUtils.isEmpty(groupItemVo.getBackList())){
                for(OrderDetailVo itemVo : groupItemVo.getBackList()){
                    poolCodeList.add(itemVo.getFeeCode());
                }
            }
        }
        vo.setPoolCodeList(poolCodeList);
        return vo;
    }


    /**
     * 从费用池验证费用是否足够
     * @param orderVo
     * @param poolMap
     * @return
     */
    public OrderVo calRapFromFee(OrderVo orderVo,Map<String, BigDecimal> poolMap){
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            if(!CollectionUtils.isEmpty(groupItemVo.getBackList())){
                for(OrderDetailVo itemVo : groupItemVo.getBackList()){
                    BigDecimal ableFee = poolMap.get(itemVo.getFeeCode());
                    if(null == ableFee){
                        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                        itemVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        StringBuilder stb = new StringBuilder("提示：货补商品【")
                                .append(itemVo.getProductName())
                                .append("】对应的费用【")
                                .append(itemVo.getFeeName())
                                .append("】剩余为0,请重新选择");
                        itemVo.setCalSucessMsg(stb.toString());
                        continue;
                    }
                    if(itemVo.getAmount().compareTo(ableFee) > 0){
                        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                        itemVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        StringBuilder stb = new StringBuilder("提示：货补商品【")
                                .append(itemVo.getProductName())
                                .append("】已超过费用【")
                                .append(itemVo.getFeeName())
                                .append("】的最大限额")
                                .append(ableFee)
                                .append("元】,请调整数量或者加大商品购买量！");
                        itemVo.setCalSucessMsg(stb.toString());
                    }
                }
            }
        }
        return orderVo;
    }


    /**
     * 计算货补限定量(多余的提示)
     * @return
     */
    public OrderVo calRep(OrderVo orderVo,String cusCode,String orgCode,BigDecimal normalAndGiftTotalAmount){
        OrderFeeRateCalToRepVo orderFeeRateCalToRepVo = this.packageOrderFeeRepParam( orderVo, cusCode, orgCode, normalAndGiftTotalAmount);
        if(null == orderFeeRateCalToRepVo){
            return orderVo;
        }
        Map<String,BigDecimal> feeMap = orderFeeRateService.calToRep(orderFeeRateCalToRepVo);
        Map<String,BigDecimal> useFeeMap = this.totalUseFee(orderVo);
        for(Map.Entry<String,BigDecimal> entry : useFeeMap.entrySet()){
            String key = entry.getKey();
            String[] keys = key.split(",");
            String productCode = keys[0];
            String productName = keys[1];
            BigDecimal maxFee = feeMap.get(productCode);
            if(null == maxFee){
                continue;
            }
            if(maxFee.compareTo(entry.getValue()) < 0){
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GLOB.getCode());
                StringBuilder stb = new StringBuilder("提示：货补商品【")
                        .append(productName)
                        .append("】已超过最大限额【")
                        .append(maxFee)
                        .append("元】,请调整数量或者加大商品购买量！");
                orderVo.setCalSucessMsg(stb.toString());
            }
        }
        return orderVo;
    }


    /**
     * 统计货补使用金额
     * @param orderVo
     * @return
     */
    public Map<String,BigDecimal> totalUseFee(OrderVo orderVo){
        Map<String,BigDecimal> useFeeMap = new HashMap<>();
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            if(CollectionUtils.isEmpty(groupItemVo.getBackList())){
                continue;
            }
            for(OrderDetailVo itemVo : groupItemVo.getBackList()){
                BigDecimal useFee = useFeeMap.get(splicingProductCodeAndName(itemVo.getProductCode(),itemVo.getProductName())) == null
                        ? BigDecimal.ZERO:useFeeMap.get(itemVo.getProductCode());
                useFeeMap.put(splicingProductCodeAndName(itemVo.getProductCode(),itemVo.getProductName()),
                        useFee.add(itemVo.getAmount()));
            }
        }
        return useFeeMap;
    }

    /**
     * 拼接产品编码和名称，中间用英文半角逗号隔开
     * @param productCode
     * @param productName
     * @return
     */
    public static String splicingProductCodeAndName(String productCode,String productName){
        return new StringBuilder(productCode).append(",").append(productName).toString();
    }


    /**
     * 组装费用限制比例查询条件
     * @param orderVo
     * @param cusCode
     * @param orgCode
     * @param normalAndGiftTotalAmount
     * @return
     */
    public OrderFeeRateCalToRepVo packageOrderFeeRepParam(OrderVo orderVo,String cusCode,String orgCode,BigDecimal normalAndGiftTotalAmount){
        OrderFeeRateCalToRepVo orderFeeRateCalToRepVo = new OrderFeeRateCalToRepVo();
        orderFeeRateCalToRepVo.setCusCode(cusCode);
        orderFeeRateCalToRepVo.setOrgCode(orgCode);
        orderFeeRateCalToRepVo.setOrderMoney(normalAndGiftTotalAmount);
        List<OrderFeeRateCalToRepProductVo> products = new ArrayList<>();
        orderFeeRateCalToRepVo.setProducts(products);
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            if(CollectionUtils.isEmpty(groupItemVo.getBackList())){
                continue;
            }
            for(OrderDetailVo itemVo : groupItemVo.getBackList()){
                OrderFeeRateCalToRepProductVo orderFeeRateCalToRepProductVo = new OrderFeeRateCalToRepProductVo();
                orderFeeRateCalToRepProductVo.setProductCode(itemVo.getProductCode());
                orderFeeRateCalToRepProductVo.setProductLevelCode(itemVo.getProductLevelCode());
                products.add(orderFeeRateCalToRepProductVo);
            }
        }
        if(CollectionUtils.isEmpty(products)){
            return null;
        }
        return orderFeeRateCalToRepVo;
    }


    /**
     * 计算订单本品+赠品总金额
     * @param orderVo
     * @return
     */
    public BigDecimal calNormalAndGiftTotalAmount(OrderVo orderVo){
        BigDecimal reNum = BigDecimal.ZERO;
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            if(!CollectionUtils.isEmpty(groupItemVo.getNormalList())){
                for(OrderDetailVo item : groupItemVo.getNormalList()){
                    reNum = reNum.add(item.getAmount());
                }
            }
            if(!CollectionUtils.isEmpty(groupItemVo.getGiftList())){
                for(OrderDetailVo item : groupItemVo.getGiftList()){
                    reNum = reNum.add(item.getAmount());
                }
            }
        }
        return reNum;
    }
}
