package com.biz.crm.order.utils;

import com.biz.crm.nebular.dms.order.OrderFileVo;
import com.biz.crm.order.entity.OrderFileEntity;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/3/2 15:18
 **/
public class OrderFileUtil {

    /**
     * 批量组装
     * @param orderCode
     * @param files
     * @return
     */
    public static List<OrderFileEntity> packageEntity(String orderCode, List<OrderFileVo> files){
        List<OrderFileEntity> entitis = new ArrayList<>();
        if(CollectionUtils.isEmpty(files)){
            return entitis;
        }
        for(OrderFileVo vo : files){
            OrderFileEntity entity = new OrderFileEntity();
            BeanUtils.copyProperties(vo, entity);
            entity.setOrderCode(orderCode);
            entitis.add(entity);
        }
        return entitis;
    }
}
