package com.biz.crm.order.utils;

import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.order.entity.OrderEntity;
import com.biz.crm.util.CodeUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/3/2 15:18
 **/
@ConditionalOnMissingBean(name = "orderUtilExpand")
@Component("orderUtil")
public class OrderUtil {

    /**
     * vo转entity 订单头
     *
     * @param orderVo
     * @return
     */
    public OrderEntity packageOrderHead(OrderVo orderVo) {
        OrderEntity orderEntity = new OrderEntity();
        BeanUtils.copyProperties(orderVo, orderEntity);
        orderEntity.setOrderCode(CodeUtil.getCodeDefault());
        return orderEntity;
    }


    /**
     * vo转entity 订单头
     *
     * @param orderVo
     * @return
     */
    public OrderEntity packageOrderHeadForEndit(OrderVo orderVo, OrderEntity orderEntity) {
        String id = orderEntity.getId();
        String orderCode = orderEntity.getOrderCode();
        BeanUtils.copyProperties(orderVo, orderEntity);
        orderEntity.setId(id);
        orderEntity.setOrderCode(orderCode);
        return orderEntity;
    }


    /**
     * 订单行号
     * 1、按照分组排序并设置组号
     * 2、循环设置行号
     *
     * @param orderVo
     * @return
     */
    public OrderVo createLineAndSort(OrderVo orderVo) {
        //1
        int groupNum = 1;
        int lineNum = 1;
        for (OrderGroupItemVo orderGroupItemVo : orderVo.getGroupItemVos()) {
            String groupCode = OrderCodeUtil.fullFour(groupNum);
            orderGroupItemVo.setGroupCode(groupCode);
            if (!CollectionUtils.isEmpty(orderGroupItemVo.getBackList())) {
                for (OrderDetailVo item : orderGroupItemVo.getBackList()) {
                    item.setGroupCode(groupCode);
                    item.setLineNo(OrderCodeUtil.fullFour(lineNum));
                    lineNum++;
                }
            }

            if (!CollectionUtils.isEmpty(orderGroupItemVo.getNormalList())) {
                for (OrderDetailVo item : orderGroupItemVo.getNormalList()) {
                    item.setGroupCode(groupCode);
                    item.setLineNo(OrderCodeUtil.fullFour(lineNum));
                    lineNum++;
                }
            }

            if (!CollectionUtils.isEmpty(orderGroupItemVo.getGiftList())) {
                for (OrderDetailVo item : orderGroupItemVo.getGiftList()) {
                    item.setGroupCode(groupCode);
                    item.setLineNo(OrderCodeUtil.fullFour(lineNum));
                    lineNum++;
                }
            }
            groupNum++;
        }

        //2
        return sort(orderVo);
    }

    /**
     * 排序
     *
     * @param orderVo
     * @return
     */
    public static OrderVo sort(OrderVo orderVo) {
        List<OrderGroupItemVo> groupItemVos = orderVo.getGroupItemVos();
        groupItemVos = groupItemVos.stream().sorted(Comparator.comparing(OrderGroupItemVo::getGroupCode))
                .collect(Collectors.toList());
        for (OrderGroupItemVo orderGroupItemVo : groupItemVos) {
            if (!CollectionUtils.isEmpty(orderGroupItemVo.getBackList())) {
                List<OrderDetailVo> list = orderGroupItemVo.getBackList().stream().sorted(Comparator.comparing(OrderDetailVo::getLineNo))
                        .collect(Collectors.toList());
                orderGroupItemVo.setBackList(list);
            }

            if (!CollectionUtils.isEmpty(orderGroupItemVo.getNormalList())) {
                List<OrderDetailVo> list = orderGroupItemVo.getNormalList().stream().sorted(Comparator.comparing(OrderDetailVo::getLineNo))
                        .collect(Collectors.toList());
                orderGroupItemVo.setNormalList(list);
            }

            if (!CollectionUtils.isEmpty(orderGroupItemVo.getGiftList())) {
                List<OrderDetailVo> list = orderGroupItemVo.getGiftList().stream().sorted(Comparator.comparing(OrderDetailVo::getLineNo))
                        .collect(Collectors.toList());
                orderGroupItemVo.setGiftList(list);
            }
        }
        orderVo.setGroupItemVos(groupItemVos);
        return orderVo;
    }

}
