package com.biz.crm.orderfeerate.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateVo;
import com.biz.crm.orderfeerate.service.OrderFeeRateService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/8 17:37
 **/
@Api(value = "管理端-订单费用使用比例", tags = "管理端-订单费用使用比例")
@RestController
@RequestMapping("/m/orderfeerate")
public class OrderFeeRatemController {

    @Resource
    private OrderFeeRateService orderFeeRateService;


    @CrmLog
    @ApiOperation(value = "新增")
    @PostMapping(value = "add")
    public Result add(@RequestBody OrderFeeRateVo orderFeeRateVo) {
        orderFeeRateService.add(orderFeeRateVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "编辑")
    @PostMapping(value = "edit")
    public Result edit(@RequestBody OrderFeeRateVo orderFeeRateVo) {
        orderFeeRateService.edit(orderFeeRateVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "通过id查询")
    @GetMapping(value = "findById/{id}")
    public Result<OrderFeeRateVo> findById(@PathVariable("id") String id) {
        return Result.ok(orderFeeRateService.findById(id));
    }

    @CrmLog
    @ApiOperation(value = "分页搜索")
    @PostMapping(value = "list")
    public Result<PageResult<OrderFeeRateVo>> list(@RequestBody OrderFeeRateVo orderFeeRateVo) {
        return Result.ok(orderFeeRateService.list(orderFeeRateVo));
    }

    @ApiOperation(value = "根据id批量删除")
    @PostMapping(value = "delByIds")
    public Result<Object> delByIds(@RequestBody ArrayList<String> ids) {
        orderFeeRateService.delByIds(ids);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation("根据id批量禁用")
    @PostMapping("enableByIds")
    public Result<Object> enable(@RequestBody ArrayList<String> ids) {
        orderFeeRateService.updateEnable(ids, CrmEnableStatusEnum.DISABLE);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation("根据id批量启用")
    @PostMapping("ableByIds")
    public Result<Object> able(@RequestBody ArrayList<String> ids) {
        orderFeeRateService.updateEnable(ids, CrmEnableStatusEnum.ENABLE);
        return Result.ok();
    }
}
