package com.biz.crm.orderfeerate.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;



import javax.persistence.Index;

import java.math.BigDecimal;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/2/25 14:29
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_order_fee_rate")
@CrmTable(name = "dms_order_fee_rate", indexes = {
        @Index(name = "index_demension", columnList = "demension"),
        @Index(name = "index_product_code", columnList = "product_code"),
        @Index(name = "index_product_level_code", columnList = "product_level_code"),
        @Index(name = "i_order_fee_rate_org_code", columnList = "org_code"),
        @Index(name = "i_order_fee_rate_cus_code", columnList = "cus_code"),
        @Index(name = "index_fee_type", columnList = "fee_type"),
        @Index(name = "unique_only_key", columnList = "only_key", unique = true)
},tableNote = "订单比例")
public class OrderFeeRateEntity extends CrmExtTenEntity<OrderFeeRateEntity> {

    /**
     * 维度
     */
    @CrmColumn(name = "demension")
    private String demension;

    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 64)
    private String productCode;

    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 100)
    private String productName;

    /**
     * 产品层级编码
     */
    @CrmColumn(name = "product_level_code", length = 64)
    private String productLevelCode;

    /**
     * 产品层级名称
     */
    @CrmColumn(name = "product_level_name", length = 100)
    private String productLevelName;

    /**
     * 组织编码
     */
    @CrmColumn(name = "org_code", length = 64)
    private String orgCode;

    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 100)
    private String orgName;

    /**
     * 客户编码
     */
    @CrmColumn(name = "cus_code", length = 64)
    private String cusCode;

    /**
     * 客户名称
     */
    @CrmColumn(name = "cus_name", length = 100)
    private String cusName;

    /**
     * 费用池类型
     */
    @CrmColumn(name = "fee_type", length = 64)
    private String feeType;

    /**
     * 每单使用百分比（0<=this<=100）
     */
    @CrmColumn(name = "rate")
    private BigDecimal rate;

    /**
     * 唯一标识，用于去重查询用
     */
    @CrmColumn(name = "only_key")
    private String onlyKey;

}
