package com.biz.crm.orderfeerate.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.dms.orderfeerate.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/2/25 14:49
 **/
public interface OrderFeeRateService {

    /**
     * 新增
     * @param orderFeeRateVo
     */
    void add(OrderFeeRateVo orderFeeRateVo);

    /**
     * 新增
     * @param orderFeeRateVo
     */
    void edit(OrderFeeRateVo orderFeeRateVo);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    OrderFeeRateVo findById(String id);

    /**
     * 分页搜索
     * @param orderFeeRateVo
     * @return
     */
    PageResult<OrderFeeRateVo> list(OrderFeeRateVo orderFeeRateVo);

    /**
     * 根据id批量删除
     * @param ids
     */
    void delByIds(ArrayList<String> ids);

    /**
     * 更新启禁用按钮
     * @param ids
     * @param crmEnableStatusEnum
     */
    void updateEnable(List<String> ids, CrmEnableStatusEnum crmEnableStatusEnum);


    /**
     * 计算订单现金费用使用比例
     * @param orderFeeRateCalToCashVo
     * @return 返回null 即不限制使用金额
     */
    BigDecimal calToCash(OrderFeeRateCalToCashVo orderFeeRateCalToCashVo);

    /**
     * 计算订单现金费用使用比例
     * @param orderFeeRateCalToCashVo
     * @return 返回null 即不限制使用金额
     */
    OrderFeeRateCalToCashResVo calToCashForObj(OrderFeeRateCalToCashVo orderFeeRateCalToCashVo);

    /**
     * 计算货补折扣最大使用量
     * @param orderFeeRateCalToRepVo
     * @return map 不会为null
     *           key->产品编码，不会为空
     *           value->最大值，为null的时候，即不限制使用金额
     */
    Map<String,BigDecimal> calToRep(OrderFeeRateCalToRepVo orderFeeRateCalToRepVo);

    /**
     * 计算货补折扣最大使用量
     * @param orderFeeRateCalToRepVo
     * @return map 不会为null
     *           key->产品编码，不会为空
     *           value->为null的时候，即不限制使用金额
     */
    Map<String, OrderFeeRateCalToResVo> calToRepForObj(OrderFeeRateCalToRepVo orderFeeRateCalToRepVo);

    /**
     * 计算订单现金费用使用比例
     * @param orderFeeRateCalToRepAndCashVo
     * @return 返回null 即不限制使用金额
     */
    BigDecimal calToRepAndCash(OrderFeeRateCalToRepAndCashVo orderFeeRateCalToRepAndCashVo);
}
