package com.biz.crm.orderfeerate.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderFeeRateEunm;
import com.biz.crm.nebular.dms.orderfeerate.*;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.orderfeerate.entity.OrderFeeRateEntity;
import com.biz.crm.orderfeerate.mapper.OrderFeeRateMapper;
import com.biz.crm.orderfeerate.service.OrderFeeRateService;
import com.biz.crm.orderfeerate.utils.OrderFeeRateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ValidateUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/2/25 14:49
 **/
@ConditionalOnMissingBean(name = "orderFeeRateServiceExpandImpl")
@Service(value = "orderFeeRateService")
public class OrderFeeRateServiceImpl<M extends BaseMapper<T>,T>
        extends ServiceImpl<OrderFeeRateMapper, OrderFeeRateEntity> implements OrderFeeRateService {

    @Autowired
    private OrderFeeRateMapper orderFeeRateMapper;

    @Resource
    private OrderFeeRateUtil orderFeeRateUtil;


    /**
     * 1、验证
     *      a,一般验证
     *      b,模式兼容验证
     *      c,重复验证
     * 2、转换
     * 3、保存
     * @param orderFeeRateVo
     */
    @Transactional
    @Override
    public void add(OrderFeeRateVo orderFeeRateVo) {
        //1
        //1.a
        orderFeeRateUtil.validate(orderFeeRateVo);
        //1.b
        String useTotal = DictUtil.dictValue(OrderFeeRateUtil.patternDicCode,OrderFeeRateUtil.useTotalDicCode);
        OrderFeeRateUtil.validatePattern(orderFeeRateVo,useTotal);
        QueryWrapper<OrderFeeRateEntity> wrapper = Wrappers.<OrderFeeRateEntity>query();
        if(useTotal.equals(YesNoEnum.yesNoEnum.YES.getValue())){
            wrapper.in("fee_type", OrderFeeRateEunm.feeTypeEunm.getReTotalCodes());
        }else {
            wrapper.eq("fee_type", OrderFeeRateEunm.feeTypeEunm.TOTAL.getCode());
        }
        Integer count = orderFeeRateMapper.selectCount(wrapper);
        if(null != count && count.intValue() > 0){
            throw new BusinessException("已存在非该费用池类型的记录，欲添加该费用池类型，请先删除所有非该费用池类型的记录！");
        }
        //1.c
        OrderFeeRateEntity entity = new OrderFeeRateEntity();
        BeanUtils.copyProperties(orderFeeRateVo,entity);
        String onlyKey = orderFeeRateUtil.packageOnlyKey(entity);
        QueryWrapper<OrderFeeRateEntity> repeatWrapper = Wrappers.<OrderFeeRateEntity>query();
        repeatWrapper.eq("only_key",onlyKey);
        Integer repeatCount = orderFeeRateMapper.selectCount(repeatWrapper);
        if(null != repeatCount && repeatCount.intValue() > 0){
            throw new BusinessException("该维度记录已经存在，请不要重复添加！");
        }

        //2
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setOnlyKey(onlyKey);

        //3
        orderFeeRateMapper.insert(entity);
    }

    /**
     * 1、验证
     *      a,一般验证
     *      b,模式兼容验证
     * 2、转换
     * 3、更新
     * @param orderFeeRateVo
     */
    @Transactional
    @Override
    public void edit(OrderFeeRateVo orderFeeRateVo) {
        //1
        //1.a
        if(StringUtils.isEmpty(orderFeeRateVo.getId())){
            throw new BusinessException("请指定要修改的记录！");
        }
        OrderFeeRateEntity entity = orderFeeRateMapper.selectById(orderFeeRateVo.getId());
        if(null == entity){
            throw new BusinessException("该记录不存在！");
        }
        orderFeeRateUtil.validate(orderFeeRateVo);
        //1.b
        String useTotal = DictUtil.dictValue(OrderFeeRateUtil.patternDicCode,OrderFeeRateUtil.useTotalDicCode);
        OrderFeeRateUtil.validatePattern(orderFeeRateVo,useTotal);
        QueryWrapper<OrderFeeRateEntity> wrapper = Wrappers.<OrderFeeRateEntity>query();
        if(useTotal.equals(YesNoEnum.yesNoEnum.YES.getValue())){
            wrapper.in("fee_type", OrderFeeRateEunm.feeTypeEunm.getReTotalCodes());
        }else {
            wrapper.eq("fee_type", OrderFeeRateEunm.feeTypeEunm.TOTAL.getCode());
        }
        Integer count = orderFeeRateMapper.selectCount(wrapper);
        if(null != count && count.intValue() > 0){
            throw new BusinessException("已存在非该费用池类型的记录，欲添加该费用池类型，请先删除所有非该费用池类型的记录！");
        }
        //1.c
        BeanUtils.copyProperties(orderFeeRateVo,entity);
        String onlyKey = orderFeeRateUtil.packageOnlyKey(entity);
        QueryWrapper<OrderFeeRateEntity> repeatWrapper = Wrappers.<OrderFeeRateEntity>query();
        repeatWrapper.eq("only_key",onlyKey);
        repeatWrapper.ne("id",entity.getId());
        Integer repeatCount = orderFeeRateMapper.selectCount(repeatWrapper);
        if(null != repeatCount && repeatCount.intValue() > 0){
            throw new BusinessException("该维度记录已经存在，请不要重复添加！");
        }

        //2
        BeanUtils.copyProperties(orderFeeRateVo,entity);
        entity.setOnlyKey(onlyKey);

        //3
        orderFeeRateMapper.updateById(entity);
    }

    @Override
    public OrderFeeRateVo findById(String id) {
        ValidateUtils.validate(id,"请指定需要查询的记录！");
        OrderFeeRateEntity entity = orderFeeRateMapper.selectById(id);
        if(null == entity){
            return null;
        }
        OrderFeeRateVo vo = new OrderFeeRateVo();
        BeanUtils.copyProperties(entity,vo);
        return vo;
    }

    @Override
    public PageResult<OrderFeeRateVo> list(OrderFeeRateVo orderFeeRateVo) {
        QueryWrapper<OrderFeeRateVo> wrapper = Wrappers.<OrderFeeRateVo>query()
                .like(!StringUtils.isEmpty(orderFeeRateVo.getProductName()), "product_name", orderFeeRateVo.getProductName())
                .eq(!StringUtils.isEmpty(orderFeeRateVo.getProductCode()), "product_code", orderFeeRateVo.getProductCode())
                .like(!StringUtils.isEmpty(orderFeeRateVo.getProductLevelName()), "product_level_name", orderFeeRateVo.getProductLevelName())
                .eq(!StringUtils.isEmpty(orderFeeRateVo.getProductLevelCode()), "product_level_code", orderFeeRateVo.getProductLevelCode())
                .like(!StringUtils.isEmpty(orderFeeRateVo.getOrgName()), "org_name", orderFeeRateVo.getOrgName())
                .eq(!StringUtils.isEmpty(orderFeeRateVo.getOrgCode()), "org_code", orderFeeRateVo.getOrgCode())
                .like(!StringUtils.isEmpty(orderFeeRateVo.getCusName()), "cus_name", orderFeeRateVo.getCusName())
                .eq(!StringUtils.isEmpty(orderFeeRateVo.getCusCode()), "cus_code", orderFeeRateVo.getCusCode())
                .eq(!StringUtils.isEmpty(orderFeeRateVo.getDemension()), "demension", orderFeeRateVo.getDemension())
                .eq(!StringUtils.isEmpty(orderFeeRateVo.getEnableStatus()), "enable_status", orderFeeRateVo.getEnableStatus());
        wrapper.orderByDesc("create_date", "create_date_second");
        Page<OrderFeeRateVo> page = PageUtil.buildPage(orderFeeRateVo.getPageNum(), orderFeeRateVo.getPageSize());
        List<OrderFeeRateVo> list = orderFeeRateMapper.list(page, wrapper);
        list = CollectionUtils.isEmpty(list)?new ArrayList<>():list;
        return PageResult.<OrderFeeRateVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Transactional
    @Override
    public void delByIds(ArrayList<String> ids) {
        if(CollectionUtils.isEmpty(ids)){
            return;
        }
        orderFeeRateMapper.deleteBatchIds(ids);
    }

    @Transactional
    @Override
    public void updateEnable(List<String> ids, CrmEnableStatusEnum crmEnableStatusEnum) {
        //1
        if(CollectionUtils.isEmpty(ids)){
            throw new BusinessException("请指定要修改的记录！");
        }

        //2
        OrderFeeRateEntity entity = new OrderFeeRateEntity();
        entity.setEnableStatus(crmEnableStatusEnum.getCode());
        QueryWrapper<OrderFeeRateEntity> wrapper = Wrappers.<OrderFeeRateEntity>query()
                .in("id", ids);
        this.update(entity,wrapper);
    }

    /**
     * 1、验证
     * 2、先查询这个客户和其组织的所有限制记录
     * 3、获取维度字典 ，排序，计算,返回第一个
     * @param vo
     * @return
     */
    @Override
    public BigDecimal calToCash(OrderFeeRateCalToCashVo vo) {
        BigDecimal reBigdecimal = null;
        //1
        ValidateUtils.validate(vo.getCusCode(),"客户编码为空!");
        ValidateUtils.validate(vo.getOrgCode(),"客户组织为空");
        ValidateUtils.validate(vo.getOrderMoney(),"订单金额为空");

        //2
        QueryWrapper<OrderFeeRateEntity> queryWrapper = Wrappers.<OrderFeeRateEntity>query()
                .in("demension",OrderFeeRateEunm.demension.getCashDemensionCodes())
                .eq("fee_type",OrderFeeRateEunm.feeTypeEunm.CASH.getCode())
                .eq("enable_status",CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.and(wrapper ->
                wrapper.eq( "cus_code", vo.getCusCode())
                .or()
                .eq("org_code", vo.getOrgCode())
        );
        List<OrderFeeRateEntity> rates = orderFeeRateMapper.selectList(queryWrapper);
        if(CollectionUtils.isEmpty(rates)){
            return reBigdecimal;
        }

        //3
        Map<String, OrderFeeRateEntity> entityMap = rates.stream().collect(Collectors.toMap(OrderFeeRateEntity::getDemension, a -> a,(k1, k2)->k1));
        List<DictDataVo> dictDataVos = DictUtil.list("order_fee_rate_demension");
        dictDataVos = dictDataVos.stream().sorted(Comparator.comparing(DictDataVo::getDictSort)).collect(Collectors.toList());
        for(DictDataVo dictDataVo : dictDataVos){
            OrderFeeRateEntity entity = entityMap.get(dictDataVo.getDictCode());
            if(null != entity){
                reBigdecimal = vo.getOrderMoney().multiply(entity.getRate())
                        .divide(new BigDecimal(100),6,BigDecimal.ROUND_HALF_UP);
                return reBigdecimal;
            }
        }
        return reBigdecimal;
    }

    /**
     * 1、验证
     * 2、先查询这个客户和其组织的所有限制记录
     * 3、获取维度字典 ，排序，计算,返回第一个
     * @param vo
     * @return
     */
    @Override
    public OrderFeeRateCalToCashResVo calToCashForObj(OrderFeeRateCalToCashVo vo) {
        OrderFeeRateCalToCashResVo reVo = null;
        //1
        ValidateUtils.validate(vo.getCusCode(),"客户编码不能为空！");
        ValidateUtils.validate(vo.getOrgCode(),"客户所属组织不能为空！");
        ValidateUtils.validate(vo.getOrderMoney(),"订单金额不能为空！");

        //2
        QueryWrapper<OrderFeeRateEntity> queryWrapper = Wrappers.<OrderFeeRateEntity>query()
                .in("demension",OrderFeeRateEunm.demension.getCashDemensionCodes())
                .eq("fee_type",OrderFeeRateEunm.feeTypeEunm.CASH.getCode())
                .eq("enable_status",CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.and(wrapper ->
                wrapper.eq( "cus_code", vo.getCusCode())
                        .or()
                        .eq("org_code", vo.getOrgCode())
        );
        List<OrderFeeRateEntity> rates = orderFeeRateMapper.selectList(queryWrapper);
        if(CollectionUtils.isEmpty(rates)){
            return reVo;
        }

        //3
        Map<String, OrderFeeRateEntity> entityMap = rates.stream().collect(Collectors.toMap(OrderFeeRateEntity::getDemension, a -> a,(k1, k2)->k1));
        List<DictDataVo> dictDataVos = DictUtil.list("order_fee_rate_demension");
        dictDataVos = dictDataVos.stream().sorted(Comparator.comparing(DictDataVo::getDictSort)).collect(Collectors.toList());
        for(DictDataVo dictDataVo : dictDataVos){
            OrderFeeRateEntity entity = entityMap.get(dictDataVo.getDictCode());
            if(null != entity){
                BigDecimal reBigdecimal = vo.getOrderMoney().multiply(entity.getRate())
                        .divide(new BigDecimal(100),6,BigDecimal.ROUND_HALF_UP);
                return new OrderFeeRateCalToCashResVo(vo.getOrderMoney(),entity.getRate(),reBigdecimal);
            }
        }
        return reVo;
    }

    /**
     * 1、验证
     * 2、查询出所有的比例
     * 3、循环计算商品的最大费用值
     * @param vo
     * @return
     */
    @Override
    public Map<String, BigDecimal> calToRep(OrderFeeRateCalToRepVo vo) {
        Map<String, BigDecimal> reMap = new HashMap<>();
        //1
        if(CollectionUtils.isEmpty(vo.getProducts())){
            return reMap;
        }
        OrderFeeRateUtil.validateForCalToRep(vo);

        //2
        QueryWrapper<OrderFeeRateEntity> queryWrapper = Wrappers.<OrderFeeRateEntity>query()
                .eq("fee_type",OrderFeeRateEunm.feeTypeEunm.REP.getCode())
                .eq("enable_status",CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.and(wrapper ->
                wrapper.eq( "cus_code", vo.getCusCode())
                        .or()
                        .eq("org_code", vo.getOrgCode()
                        )
                .or(wrapper1 ->
                        wrapper1.eq("cus_code", StringUtils.EMPTY)
                                .and(wrapper2 ->
                                        wrapper2.eq("org_code", StringUtils.EMPTY))
                )
        );
        List<OrderFeeRateEntity> rates = orderFeeRateMapper.selectList(queryWrapper);

        //3
        List<DictDataVo> dictDataVos = DictUtil.list("order_fee_rate_demension");
        dictDataVos = dictDataVos.stream().sorted(Comparator.comparing(DictDataVo::getDictSort)).collect(Collectors.toList());
        for(OrderFeeRateCalToRepProductVo product : vo.getProducts()){
            BigDecimal maxFee = null;
            reMap.put(product.getProductCode(),maxFee);
            //找出费率
            List<OrderFeeRateEntity> rateEntityList = OrderFeeRateUtil.filterRate(rates,product);
            if(CollectionUtils.isEmpty(rateEntityList)){
                continue;
            }
            Map<String, OrderFeeRateEntity> entityMap = rateEntityList.stream().collect(Collectors.toMap(OrderFeeRateEntity::getDemension, a -> a,(k1, k2)->k1));
            for(DictDataVo dictDataVo : dictDataVos){
                OrderFeeRateEntity entity = entityMap.get(dictDataVo.getDictCode());
                if(null != entity){
                    maxFee = vo.getOrderMoney().multiply(entity.getRate())
                            .divide(new BigDecimal(100),2,BigDecimal.ROUND_HALF_UP);
                }
            }
            reMap.put(product.getProductCode(),maxFee);
        }
        return reMap;
    }

    /**
     * 1、验证
     * 2、查询出所有的比例
     * 3、循环计算商品的最大费用值
     * @param vo
     * @return
     */
    @Override
    public Map<String, OrderFeeRateCalToResVo> calToRepForObj(OrderFeeRateCalToRepVo vo) {
        Map<String, OrderFeeRateCalToResVo> reMap = new HashMap<>();
        //1
        if(CollectionUtils.isEmpty(vo.getProducts())){
            return reMap;
        }
        OrderFeeRateUtil.validateForCalToRep(vo);

        //2
        QueryWrapper<OrderFeeRateEntity> queryWrapper = Wrappers.<OrderFeeRateEntity>query()
                .eq("fee_type",OrderFeeRateEunm.feeTypeEunm.REP.getCode())
                .eq("enable_status",CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.and(wrapper ->
                wrapper.eq( "cus_code", vo.getCusCode())
                        .or()
                        .eq("org_code", vo.getOrgCode()
                        )
                        .or(wrapper1 ->
                                wrapper1.eq("cus_code", StringUtils.EMPTY)
                                        .and(wrapper2 ->
                                                wrapper2.eq("org_code", StringUtils.EMPTY))
                        )
        );
        List<OrderFeeRateEntity> rates = orderFeeRateMapper.selectList(queryWrapper);

        //3
        List<DictDataVo> dictDataVos = DictUtil.list("order_fee_rate_demension");
        dictDataVos = dictDataVos.stream().sorted(Comparator.comparing(DictDataVo::getDictSort)).collect(Collectors.toList());
        for(OrderFeeRateCalToRepProductVo product : vo.getProducts()){
            OrderFeeRateCalToResVo obj = null;
            //找出费率
            List<OrderFeeRateEntity> rateEntityList = OrderFeeRateUtil.filterRate(rates,product);
            if(CollectionUtils.isEmpty(rateEntityList)){
                reMap.put(product.getProductCode(),obj);
                continue;
            }
            Map<String, OrderFeeRateEntity> entityMap = rateEntityList.stream().collect(Collectors.toMap(OrderFeeRateEntity::getDemension, a -> a,(k1, k2)->k1));
            for(DictDataVo dictDataVo : dictDataVos){
                OrderFeeRateEntity entity = entityMap.get(dictDataVo.getDictCode());
                if(null != entity){
                    BigDecimal maxFee = vo.getOrderMoney().multiply(entity.getRate())
                            .divide(new BigDecimal(100),2,BigDecimal.ROUND_HALF_UP);
                    obj = new OrderFeeRateCalToResVo(vo.getOrderMoney(),entity.getRate(),maxFee);
                }
            }
            reMap.put(product.getProductCode(),obj);
        }
        return reMap;
    }

    /**
     * 1、验证
     * 2、先查询这个客户和其组织的所有限制记录
     * 3、获取维度字典 ，排序，计算,返回第一个
     * @param vo
     * @return
     */
    @Override
    public BigDecimal calToRepAndCash(OrderFeeRateCalToRepAndCashVo vo) {
        BigDecimal reBigdecimal = null;
        //1
        ValidateUtils.validate(vo.getCusCode(),"客户编码为空!");
        ValidateUtils.validate(vo.getOrgCode(),"客户组织为空");
        ValidateUtils.validate(vo.getOrderMoney(),"订单金额为空");

        //2
        QueryWrapper<OrderFeeRateEntity> queryWrapper = Wrappers.<OrderFeeRateEntity>query()
                .in("demension",OrderFeeRateEunm.demension.getCashAndRepDemensionCodes())
                .eq("fee_type",OrderFeeRateEunm.feeTypeEunm.TOTAL.getCode())
                .eq("enable_status",CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.and(wrapper ->
                wrapper.eq( "cus_code", vo.getCusCode())
                        .or()
                        .eq("org_code", vo.getOrgCode())
        );
        List<OrderFeeRateEntity> rates = orderFeeRateMapper.selectList(queryWrapper);
        if(CollectionUtils.isEmpty(rates)){
            return reBigdecimal;
        }

        //3
        Map<String, OrderFeeRateEntity> entityMap = rates.stream().collect(Collectors.toMap(OrderFeeRateEntity::getDemension, a -> a,(k1, k2)->k1));
        List<DictDataVo> dictDataVos = DictUtil.list("order_fee_rate_demension");
        dictDataVos = dictDataVos.stream().sorted(Comparator.comparing(DictDataVo::getDictSort)).collect(Collectors.toList());
        for(DictDataVo dictDataVo : dictDataVos){
            OrderFeeRateEntity entity = entityMap.get(dictDataVo.getDictCode());
            if(null != entity){
                reBigdecimal = vo.getOrderMoney().multiply(entity.getRate())
                        .divide(new BigDecimal(100),6,BigDecimal.ROUND_HALF_UP);
                return reBigdecimal;
            }
        }
        return reBigdecimal;
    }
}
