package com.biz.crm.promotion.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.promotion.service.ExcelHandleService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * excel表格处理控制器
 * @Author: chenrong
 * @Date: 2021/1/26 10:37
 */
@Api(value = "excel表格处理控制器")
@RestController
@RequestMapping(value = "/promotion/excel")
public class ExcelHandleController {

  @Resource
  private ExcelHandleService excelHandleService;

  @GetMapping(value = "downloadUncludeCusTemplate")
  @ApiOperation(value = "下载非包含客户导入模板")
  public void downloadUncludeCusTemplate(HttpServletResponse response){
    this.excelHandleService.downloadUncludeCusTemplate(response);
  }

  @CrmLog
  @ApiOperation(value = "解析非包含客户excel数据")
  @PostMapping(value = "analysisUncludeExcel")
  public Result analysisUncludeExcel(HttpServletRequest request) {
    List<MdmCustomerMsgRespVo> result = this.excelHandleService.analysisUncludeExcel(request);
    return Result.ok(result);
  }

}
