package com.biz.crm.promotion.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.promotion.service.PromotionRuleService;
import com.biz.crm.util.Result;
import com.bizunited.platform.common.vo.IDParamVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;


/**
 *  @author: luoqi
 *  @Date: 2020-10-15 16:50
 *  @version: V1.0
 *  @Description:
 */
@Api(value = "管理端-促销规则", tags = "管理端-促销规则")
@RestController
@RequestMapping("/promotion/rule")
public class PomotionRuleController {

    @Resource
    private PromotionRuleService promotionRuleService;


    @CrmLog
    @ApiOperation(value = "新增、修改规则")
    @PostMapping
    public Result addOrUpdate(@RequestBody PromotionRuleEditVo vo) {
        Result result = Result.ok( );
        result.setResult(promotionRuleService.addOrUpdate(vo));
        return result;
    }
    @CrmLog
    @ApiOperation(value = "测试脚本体")
    @PostMapping("testfunc")
    public Result<Object> testFunc(@RequestBody PromotionRuleEditVo vo) {
        return Result.ok(promotionRuleService.testFunc(vo));
    }
    @CrmLog
    @ApiOperation(value = "加载规则编辑页面数据")
    @CrmDictMethod
    @GetMapping("editinfo")
    public Result<PromotionRuleEditVo> loadEditVoById(@RequestParam("id") String id) {
        return Result.ok(promotionRuleService.loadEditVoById(id));
    }


    @CrmLog
    @ApiOperation(value = "删除")
    @PostMapping("del/{id}")
    public Result del(@PathVariable("id") String id) {
        promotionRuleService.del(id);
        return Result.ok();
    }
}
