package com.biz.crm.promotion.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.vo.ActivitiBusinessVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionAvailableResp;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionQueryReq;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionScopeSourceVo;
import com.biz.crm.nebular.dms.promotion.PromotionInfoRespVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyQueryVo;
import com.biz.crm.promotion.service.IDmsPromotionPolicyOrderDetailService;
import com.biz.crm.promotion.service.npromotion.PromotionComputeService;
import com.biz.crm.promotion.service.npromotion.PromotionService;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * @author: luoqi
 * @Date: 2020-10-15 16:50
 * @version: V1.0
 * @Description:
 */
@Api(value = "促销政策（新）", tags = "促销政策（新）")
@RestController
@RequestMapping("/promotion/v2")
public class PromotionController {

  @Resource
  private PromotionService promotionService;
  @Resource
  private PromotionComputeService promotionComputeService;
  @Resource
  private IDmsPromotionPolicyOrderDetailService dmsPromotionPolicyOrderDetailService;
  @Autowired
  private RedisService redisService;


    @CrmLog
    @ApiOperation(value = "通过参数查询促销政策集合(目前需要支持通过促销政策编码集合promotionCodes和是否是查询有效的政策的标识queryEffectiveFlag)")
    @PostMapping("/findPromotionsByParam")
    public Result<PageResult<PromotionInfoRespVo>> findPromotionsByParam(@RequestBody PromotionPolicyQueryVo reqVo) {
        return Result.ok(promotionService.findPromotionsByParam(reqVo));
    }

  @CrmLog
  @ApiOperation("创建促销政策")
  @PostMapping("/create")
  public Result<PromotionEditVo> create(@RequestBody PromotionEditVo promotionEditVo) {
    PromotionEditVo result = this.promotionService.create(promotionEditVo);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation("更新促销政策")
  @PostMapping("/update")
  public Result<PromotionEditVo> update(@RequestBody PromotionEditVo promotionEditVo) {
    PromotionEditVo result = this.promotionService.update(promotionEditVo);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation("根据id查询详情")
  @GetMapping("/findDetailsById/{id}")
  public Result<PromotionEditVo> findDetailsById(@PathVariable(name = "id") String id) {
    PromotionEditVo result = this.promotionService.findDetailsById(id);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation("分页查询促销范围数据源")
  @PostMapping("/findScopeSourcePage")
  public Result<PageResult<PromotionScopeSourceVo>> findScopeSourcePage(@RequestBody PromotionScopeSourceVo param) {
    PageResult<PromotionScopeSourceVo> result = this.promotionService.findScopeSourcePage(param);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation("分页查询促销政策")
  @PostMapping("/findPromotionPageByConditions")
  public Result<PageResult<PromotionEditVo>> findPromotionPageByConditions(@RequestBody PromotionEditVo param) {
    PageResult<PromotionEditVo> result = this.promotionService.findPromotionPageByConditions(param);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation("根据客户以及商品（本品）查询可用的所有促销政策")
  @PostMapping("/findAvailablePromotionsByAccount")
  public Result<List<PromotionAvailableResp>> findAvailablePromotionsByAccount(@RequestBody PromotionQueryReq param) {
    List<PromotionAvailableResp> result = this.promotionComputeService.findAvailablePromotionsByAccount(param);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation("根据促销政策编码列表查询促销政策命中情况")
  @PostMapping("/findHitPromotionsByPromotionCodes")
  public Result<List<PromotionEditVo>> findHitPromotionsByPromotionCodes(@RequestBody PromotionQueryReq param) {
    List<PromotionEditVo> result = this.promotionComputeService.findHitPromotionsByPromotionCodes(param);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation("根据促销政策编码列表查询促销政策命中情况")
  @PostMapping(value = "findHitPromotionMapByPromotionCodes")
  public Result<Map<String, PromotionEditVo>> findHitPromotionMapByPromotionCodes(@RequestBody ArrayList<PromotionQueryReq> params) {
    Map<String, PromotionEditVo> result = this.promotionComputeService.findHitPromotionMapByPromotionCodes(params);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation(value = "根据客户查询是否有可用政策")
  @PostMapping(value = "/findAvailablePromotionMapByCus")
  public Result<Map<String, Boolean>> findAvailablePromotionMapByCus(@RequestBody PromotionQueryReq param) {
      Map<String, Boolean> result = this.promotionComputeService.findAvailablePromotionMapByCus(param);
      return Result.ok(result);
  }




  @CrmLog
  @ApiOperation(value = "促销政策提交")
  @PostMapping(value = "/submit")
  public Result submit(@RequestBody ActivitiBusinessVo activitiBusinessVo){
      String no =  promotionService.submit(activitiBusinessVo);
      return Result.ok("提交成功流程编号["+no+"]");
  }

  /**
   * 审批流回调方法
   *
   * @return
   */
  @CrmLog
  @ApiOperation(value = "审批流回调方法")
  @PostMapping(value = "/callback")
  Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
    this.promotionService.callback(activitiCallBackVo);
    return Result.ok();
  }


}
