package com.biz.crm.promotion.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.dms.promotion.*;
import com.biz.crm.nebular.dms.promotion.param.QueryProductPolicyParamVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.PromotionPolicyInfoDataVo;
import com.biz.crm.promotion.entity.resp.PromotionPolicyPageResp;
import com.biz.crm.promotion.service.PromotionPolicyService;
import com.biz.crm.promotion.service.component.RuleExecuteParam;
import com.biz.crm.promotion.service.component.RuleExecutor;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.promotion.service.npromotion.PromotionService;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;


/**
 *  @author: luoqi
 *  @Date: 2020-10-15 16:50
 *  @version: V1.0
 *  @Description:
 */
@Api(value = "管理端-促销政策", tags = "管理端-促销政策")
@RestController
@RequestMapping("/promotion/policy")
public class PromotionPolicyController {

    @Resource
    private PromotionPolicyService promotionPolicyService;
    @Resource(name = "defaultRuleExecutor")
    private RuleExecutor defaultRuleExecutor;
    @Resource
    private PromotionService promotionService;


    @CrmLog
    @ApiOperation(value = "新增、修改政策")
    @PostMapping
    public Result addOrUpdate(@RequestBody PromotionPolicyEditReqVo vo) {
        promotionPolicyService.addOrUpdate(vo);
        return Result.ok();
    }
    @CrmLog
    @ApiOperation(value = "查询给定的客户在给定的商品下能够享受的促销政策")
    @GetMapping("custandproduct")
    public Result<List<PromotionPolicyInfoDataVo>> loadPromotionPolicyInfoByCustAndProduct(@RequestParam("custCode")String custCode
            , @RequestParam("productCode")String productCode) {
        return Result.ok(promotionPolicyService.loadPromotionPolicyInfoByCustAndProduct(custCode, productCode));
    }
    @CrmLog
    @ApiOperation(value = "查询给定的客户在给定的商品列表下能够享受的促销政策")
    @PostMapping("custandproducts")
    public Result<Map<String, List<PromotionPolicyInfoVo>>> loadPromotionPolicyInfoByCustAndProducts(@RequestParam("custCode")String custCode
            , @RequestBody() List<String> productCodes) {
        return Result.ok(promotionPolicyService.loadPromotionPolicyInfoByCustAndProducts(custCode, productCodes));
    }
    @CrmLog
    @ApiOperation(value = "给定的客户在给定的商品列表下是否能享受促销政策")
    @PostMapping("custProductsHasPromotionPolicy")
    public Result<Map<String, Boolean>> custProductsHasPromotionPolicy(@RequestParam("custCode")String custCode
            , @RequestBody() List<String> productCodes) {
        return Result.ok(promotionPolicyService.custProductsHasPromotionPolicy(custCode, productCodes));
    }
    @CrmLog
    @ApiOperation(value = "加载政策编辑页面数据")
    @GetMapping("editinfo")
    public Result<PromotionPolicyEditVo> loadPolicyEditVo(@RequestParam(value = "id", required = false)String id
            , @RequestParam(value = "templateId", required = false) String templateId) {
        return Result.ok(promotionPolicyService.loadPolicyEditVo(id, templateId));
    }

    @CrmLog
    @ApiOperation(value = "分页搜索")
    @CrmDictMethod
    @PostMapping(value = "page")
    public Result<PageResult<PromotionPolicyPageResp>> getPageList(@RequestBody PromotionPolicyQueryVo vo) {
        return Result.ok(promotionPolicyService.getPageList(vo));
    }

    @CrmLog
    @ApiOperation(value = "删除")
    @PostMapping("del")
    public Result del(@RequestBody List<String> promotionPolicyIds) {
        promotionPolicyService.del(promotionPolicyIds);
        return Result.ok();
    }
    @CrmLog
    @ApiOperation(value = "禁用")
    @PostMapping(value = "disable")
    public Result disable(@RequestBody List<String> promotionPolicyIds) {
        promotionPolicyService.disable(promotionPolicyIds);
        return Result.ok();
    }
    @CrmLog
    @ApiOperation(value = "启用")
    @PostMapping(value = "enable")
    public Result enable(@RequestBody List<String> promotionPolicyIds) {
        promotionPolicyService.enable(promotionPolicyIds);
        return Result.ok();
    }
    @CrmLog
    @ApiOperation(value = "加载订单下所有商品享受的促销政策和政策规则配置信息")
    @PostMapping(value = "loadPromotionPolicyConfigInfoForOrder")
    public Result< Map<String, List<PromotionPolicyConfigInfo>> > loadPromotionPolicyConfigInfoForOrder(@RequestBody PromotionPolicyConfigInfoQueryVo configInfoQueryVo){
        return Result.ok(promotionPolicyService.loadPromotionPolicyConfigInfoForOrder(configInfoQueryVo));
    }

    @CrmLog
    @ApiOperation(value = "加载商品享受的促销政策和政策规则配置信息")
    @PostMapping(value = "loadPromotionPolicyConfigInfoByProductCode")
    public Result<List<PromotionPolicyConfigInfo> > loadPromotionPolicyConfigInfoByProductCode(@RequestBody QueryProductPolicyParamVo productPolicyParamVo){
        return Result.ok(promotionPolicyService.loadPromotionPolicyConfigInfoByProductCode(productPolicyParamVo));
    }

    @CrmLog
    @ApiOperation(value = "默认政策业务规则执行实现")
    @PostMapping(value = "testDefaultRuleExecutor")
    public Result<CalculateRuleResponse> testDefaultRuleExecutor(@RequestBody RuleExecuteParam shellParam){
        return Result.ok(defaultRuleExecutor.execute(shellParam));
    }

    @CrmLog
    @ApiOperation(value = "计算给定日期生效和失效政策影响到的客户列表")
    @PostMapping(value = "countBeginAndEndAffectedCustoms")
    public Result<List<String>> countBeginAndEndAffectedCustoms(@RequestParam(value ="date", required = false) String date){
        return Result.ok(promotionPolicyService.countBeginAndEndAffectedCustoms(date, null));
    }

    @CrmLog
    @ApiOperation(value = "订单选择商品和数量下拉选")
    @PostMapping(value = "loadPromotionPolicyConfigInfoForSelect")
    public Result< Map<String, List<PromotionPolicyConfigInfo>> > loadPromotionPolicyConfigInfoForSelect(@RequestBody PromotionPolicyConfigInfoQueryVo configInfoQueryVo) {
        return Result.ok(promotionPolicyService.loadPromotionPolicyConfigInfoForSelect(configInfoQueryVo));
    }

    @CrmLog
    @ApiOperation(value = "根据客户查询所有可用促销（商品编码作为key）")
    @GetMapping(value = "findProductMapByCusCode")
    public Result<Map<String, List<PromotionPolicyConfigInfo>>> findProductMapByCusCode(@RequestParam(value ="cusCode", required = false) String cusCode) {
        Map<String, List<PromotionPolicyConfigInfo>> result = this.promotionPolicyService.findProductMapByCusCode(cusCode);
        return Result.ok(result);
    }

    @CrmLog
    @ApiOperation(value = "根据id查询详情")
    @GetMapping(value = "findDetailsById/{id}")
    public Result<PromotionEditVo> findDetailsById(@PathVariable(name = "id") String id) {
        PromotionEditVo result = promotionService.findDetailsById(id);
        return Result.ok(result);
    }
}
