package com.biz.crm.promotion.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.nebular.dms.promotion.*;
import com.biz.crm.promotion.service.PromotionPolicyProductService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;


/**
 * @author xi.peng
 */
@Api(value = "管理端-促销政策商品", tags = "管理端-促销政策")
@RestController
@RequestMapping("/promotion/policyproduct")
public class PromotionPolicyProductController {

    @Resource
    private PromotionPolicyProductService promotionPolicyProductService;

    @CrmLog
    @ApiOperation(value = "根据促销政策编码集合查询促销政策商品列表")
    @PostMapping(value = "selectListByPromotionPolicyCodes")
    public Result<List<PromotionPolicyProductRespVo>> selectListByPromotionPolicyCodes(@RequestBody PromotionPolicyCodesVo reqVo) {
        return Result.ok(promotionPolicyProductService.selectListByPromotionPolicyCodes(reqVo));
    }

}
