package com.biz.crm.promotion.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.config.CrmDict;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;


/**
 * 促销政策
 *  @author: luoqi
 *  @Date: 2020-10-15 14:56
 *  @version: V1.0
 *  @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_promotion_policy")
@CrmTable(name = "dms_promotion_policy",tableNote = "促销政策主表")
public class PromotionPolicyEntity extends CrmExtEntity<PromotionPolicyEntity> {
    public static final String ALL = "ALL";

    /**
     * 促销编码
     */
    @CrmColumn(name = "promotion_policy_code", length = 64, unique = true)
    private String promotionPolicyCode;

    /**
     * 促销名称
     */
    @CrmColumn(name = "promotion_policy_name", length = 100)
    private String promotionPolicyName;

    /**
     * 促销政策模板模板id
     */
    @ApiModelProperty(value = "促销政策模板模板id")
    @CrmColumn(name = "template_id", length = 64)
    private String templateId;

    /**
     * 促销政策模板模板code
     */
    @ApiModelProperty(value = "促销政策模板模板编码")
    @CrmColumn(name = "template_code", length = 64)
    private String templateCode;

    /**
     * 促销政策模板模板name
     */
    @ApiModelProperty(value = "促销政策模板模板名称")
    @CrmColumn(name = "template_name", length = 100)
    private String templateName;

    /**
     * 有效期开始
     */
    @ApiModelProperty(value = "有效期开始-时间")
    @CrmColumn(name = "begin_time", length = 20)
    private String beginTime;


    /**
     * 有效期结束
     */
    @ApiModelProperty(value = "有效期结束-时间")
    @CrmColumn(name = "end_time", length = 20)
    private String endTime;


    /**
     * 政策叠加 字典：yesOrNo
     */
    @ApiModelProperty(value = "政策叠加 字典：yesOrNo")
    @CrmColumn(name = "multipleable", length = 64)
    private String multipleable;

    @ApiModelProperty(value = "政策叠加字典翻译 字典：yesOrNo")
    @CrmDict(typeCode = "yesOrNo",dictCodeField = "multipleable")
    @TableField(exist = false)
    private String multipleableName;
    /**
     * 首单享受 字典：yesOrNo
     */
    @ApiModelProperty(value = "首单享受 字典：yesOrNo")
    @CrmColumn(name = "first_order", length = 64)
    private String firstOrder;

    @ApiModelProperty(value = "首单享受字典翻译 字典：yesOrNo")
    @CrmDict(typeCode = "yesOrNo",dictCodeField = "firstOrder")
    @TableField(exist = false)
    private String firstOrderName;
    /**
     * 促销描述
     */
    @ApiModelProperty(value = "促销描述")
    @CrmColumn(name = "description")
    private String description;

    /**
     * 商品组合起订量
     */
    @ApiModelProperty(value = "商品组合起订量")
    @CrmColumn(name = "products_order_qty")
    private BigDecimal productsOrderQty;

    /**
     * 组合起订量类型
     */
    @ApiModelProperty(value = "组合起订量类型")
    @CrmColumn(name = "products_order_qty_type", length = 64)
    private String productsOrderQtyType;

    @ApiModelProperty(value = "组合起订量类型字典翻译")
    @CrmDict(typeCode = "products_order_qty_type",dictCodeField = "productsOrderQtyType")
    @TableField(exist = false)
    private String productsOrderQtyTypeName;

    /**
     * 活动规划行号
     */
    @ApiModelProperty(value = "活动规划行号")
    @CrmColumn(name = "act_plan_no", length = 64)
    private String actPlanNo;

    /**
     * 费率
     */
    @ApiModelProperty(value = "费率")
    @CrmColumn(name = "fee_rate")
    private BigDecimal feeRate;
    /**
     * 渠道
     */
    @ApiModelProperty(value = "渠道")
    @CrmColumn(name = "chanel", length = 64)
    private String chanel;
    /**
     * 销售公司编码
     */
    @ApiModelProperty(value = "销售公司编码")
    @CrmColumn(name = "sale_company_code", length = 64)
    private String saleCompanyCode;
    /**
     * 销售公司
     */
    @ApiModelProperty(value = "销售公司")
    @CrmColumn(name = "sale_company_name", length = 100)
    private String saleCompanyName;

    /**
     * 政策使用量上限
     */
    @ApiModelProperty(value = "政策使用量上限")
    @CrmColumn(name = "used_qty_upper")
    private BigDecimal usedQtyUpper;

    /**
     * 销售范围类型，customer:经销商，terminal:终端，默认经销商
     */
    @ApiModelProperty(value = "销售范围类型，customer:经销商，terminal:终端")
    @CrmColumn(name = "scope_type", length = 64)
    private String scopeType = "customer";

    /**
     * 促销类型 字典：promotion_type
     */
    @CrmColumn(name = "promotion_type", note = "促销类型", length = 64)
    private String promotionType;

    @CrmColumn(name = "compose_state", note = "是否本品组合政策", length = 1)
    private boolean composeState;

    @ApiModelProperty(value = "是否不展示到前端")
    @CrmColumn(name = "not_show", note = "是否不展示到前端")
    private Integer notShow;

    @ApiModelProperty(value = "父级促销政策编码")
    @CrmColumn(name = "parent_code", note = "父级促销政策编码", length = 63)
    private String parentCode;

    /**    审批相关  **/
    @CrmColumn(name = "bpm_status", note = "审批状态(数据字典bpm_status)", length = 10)
    private String bpmStatus;
    @CrmColumn(name = "crm_process_instance_id", length = 60,note = "流程编号")
    private String crmProcessInstanceId;
    @CrmColumn(name = "bpm_submit_date", note = "流程提交时间", length = 40)
    private String bpmSubmitDate;
    @CrmColumn(name = "bpm_pass_date", note = "流程通过时间", length = 40)
    private String bpmPassDate;
    @CrmColumn(name = "bpm_submit_by", note = "提交人", length = 40)
    private String bpmSubmitBy;

}
