package com.biz.crm.promotion.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmExtEntity;


import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;


/**
 * 促销政策模板
 *  @author: luoqi
 *  @Date: 2020-10-15 14:56
 *  @version: V1.0
 *  @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_promotion_policy_template")
@CrmTable(name = "dms_promotion_policy_template",tableNote = "促销政策模板")
public class PromotionPolicyTemplateEntity extends CrmExtEntity<PromotionPolicyTemplateEntity> {

    /**
     * 模板名称
     */
    @CrmColumn(name = "template_name", length = 100)
    private String templateName;

    /**
     * 模板编码
     */
    @CrmColumn(name = "template_code", length = 64, unique = true)
    private String templateCode;

    /**
     * 促销类型 字典：promotion_type
     */
    @CrmColumn(name = "promotion_type", length = 64)
    private String promotionType;

    /**
     * 促销商品
     */
    @CrmColumn(name = "promotion_product")
    private String promotionProduct;




}
