package com.biz.crm.promotion.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.dms.promotion.policy.req.DmsPromotionPolicyOrderDetailReqVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.DmsPromotionPolicyOrderDetailRespVo;
import com.biz.crm.promotion.entity.DmsPromotionPolicyOrderDetailEntity;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 促销政策订单明细
 * 
 * @author lf
 * @date 2020-12-26 13:34:30
 */
public interface DmsPromotionPolicyOrderDetailMapper extends BaseMapper<DmsPromotionPolicyOrderDetailEntity> {
    /**
     * 列表
     * @param page
     * @param dmsPromotionPolicyOrderDetailReqVo
     * @return
     */
    List<DmsPromotionPolicyOrderDetailRespVo> findList(Page<DmsPromotionPolicyOrderDetailRespVo> page, @Param("vo") DmsPromotionPolicyOrderDetailReqVo dmsPromotionPolicyOrderDetailReqVo);

    /**
     * 通过id查询
     * @param id
     * @return
     */
    DmsPromotionPolicyOrderDetailEntity selectDmsPromotionPolicyOrderDetailEntityById(String id);

    /**
     * 查询已使用的促销政策明细
     * @param id
     * @return
     */
    BigDecimal selectPromotionPolicyUsedQty(String id);

}
