package com.biz.crm.promotion.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyCodesVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyProductRespVo;
import com.biz.crm.promotion.entity.PromotionPolicyProductEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 *  @author: luoqi
 *  @Date: 2020-10-15 16:50
 *  @version: V1.0
 *  @Description:
 */
public interface PromotionPolicyProductMapper extends BaseMapper<PromotionPolicyProductEntity> {
    /**
     * 查询该商品对应的政策id列表
     * @param productCode
     * @return
     */
    List<String> selectPromotionPolicyIdByProductCode(String productCode);
    /**
     * 查询该商品对应的政策列表
     * @param productCodes
     * @return
     */
    List<PromotionPolicyProductEntity> selectPromotionPolicyIdByProductCodes(@Param("productCodes") List<String> productCodes);
    /**
     * 根据促销政策编码集合查询促销政策商品列表
     * @param reqVo
     * @return
     */
    List<PromotionPolicyProductRespVo> selectListByPromotionPolicyCodes(@Param("vo") PromotionPolicyCodesVo reqVo);
}
