package com.biz.crm.promotion.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.dms.npromotion.vo.DmsPromotionPolicyOrderDetailVo;
import com.biz.crm.nebular.dms.promotion.policy.req.DmsPromotionPolicyOrderDetailReqVo;
import com.biz.crm.promotion.entity.DmsPromotionPolicyOrderDetailEntity;
import java.util.List;

/**
 * 促销政策订单明细接口
 * @author lf
 * @date 2020-12-26 13:34:30
 */
public interface IDmsPromotionPolicyOrderDetailService extends IService<DmsPromotionPolicyOrderDetailEntity> {


//    Boolean lockPromotionPolicyOrderDetailList(List<DmsPromotionPolicyOrderDetailReqVo> reqVoList);


  /**
   * 锁定促销明细使用
   * @param reqVo
   * @return
   */
  Boolean lockPromotionPolicyOrderDetail(DmsPromotionPolicyOrderDetailReqVo reqVo);

  /**
   * 批量锁定促销明细使用
   * @param reqVo
   * @return
   */
  Boolean lockPromotionPolicyOrderDetailBatch(List<DmsPromotionPolicyOrderDetailReqVo> reqVo);

  /**
   * 提交促销明细使用
   * @param orderNo
   * @return
   */
  Boolean commitPromotionPolicyOrderDetail(String orderNo);

  /**
   * 锁定并提交促销明细使用
   * @param reqVo
   * @return
   */
  Boolean lockAndSubmitPromotionPolicyOrderDetail(DmsPromotionPolicyOrderDetailReqVo reqVo);

  /**
   * 解除锁定促销明细使用
   * @param orderNo
   * @return
   */
  Boolean unlockPromotionPolicyOrderDetail(String orderNo);

  /**
   * 回滚促销政策使用明细
   * @param orderNo
   * @return
   */
  Boolean rollbackPromotionPolicyOrderDetail(String orderNo);

}

