package com.biz.crm.promotion.service;

import com.biz.crm.nebular.dms.promotion.PromotionPolicyCodesVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditReqVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyProductRespVo;
import com.biz.crm.promotion.entity.PromotionPolicyProductEntity;
import com.biz.crm.promotion.service.impl.LoadConfigInfoContext;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 *  @author: luoqi
 *  @Date: 2020-10-15 16:42
 *  @version: V1.0
 *  @Description:
 */
public interface PromotionPolicyProductService {
    /**
     *刷新政策促销商品，字段校验由调用方执行
     *  @author: luoqi
     *  @Date: 2020-10-19 16:28
     *  @version: V1.0
     *  @Description:
     */
    void refreshProduct(PromotionPolicyEditReqVo editVo);

    /**
     * 加载政策编辑页面促销商品
     *  @author: luoqi
     *  @Date: 2020-10-20 20:47
     *  @version: V1.0
     *  @Description:
     */
    void loadListForEditPromotionPolicy(PromotionPolicyEditVo editVo);

    /**
     * 按政策id或政策code 批量删除
     *  @author: luoqi
     *  @Date: 2020-10-20 16:01
     *  @version: V1.0
     *  @Description:
     */
    void delByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode);

    /**
     * 查询该商品对应的政策id列表
     * @param productCode
     * @return
     */
    Set<String> selectPromotionPolicyIdByProductCode(String productCode);
    /**
     * 查询该商品对应的政策列表
     * @param productCodes
     * @return
     */
    List<PromotionPolicyProductEntity> selectPromotionPolicyIdByProductCodes(List<String> productCodes);
    /**
     * 根据促销政策编码集合查询促销政策商品列表
     * @param reqVo
     * @return
     */
    List<PromotionPolicyProductRespVo> selectListByPromotionPolicyCodes(PromotionPolicyCodesVo reqVo);
    /**
     * 查询政策的商品列表
     * @return
     */
    void selectGiftByPromotionPolicyId(LoadConfigInfoContext loadConfigInfoContext, String isGift);

    /**
     * 根据政策id列表查询商品
     * @param promotionIds
     * @param isCurrent
     * @return
     */
    Map<String, List<PromotionPolicyProductEntity>> findProductsByPromotionIds(ArrayList<String> promotionIds, String isCurrent);
}
