package com.biz.crm.promotion.service;

import com.biz.crm.promotion.enums.AccountTypeDynamicEnum;
import com.biz.crm.eunm.dms.ScopeTypeDynamicEnum;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditReqVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditVo;

import java.util.List;
import java.util.Set;

/**
 *  @author: luoqi
 *  @Date: 2020-10-15 16:42
 *  @version: V1.0
 *  @Description:
 */
public interface PromotionPolicyScopeService {


    /**
     *
     *  @author: luoqi
     *  @Date: 2020-10-19 16:28
     *  @version: V1.0
     *  @Description:
     */
    void refreshScope(PromotionPolicyEditReqVo editVo);

    /**
     * 加载政策编辑页面促销范围
     *  @author: luoqi
     *  @Date: 2020-10-20 21:16
     *  @version: V1.0
     *  @Description:
     */
    void loadListForEditPromotionPolicy(PromotionPolicyEditVo editVo);
    /**
     * 按政策id或政策code 批量删除
     *  @author: luoqi
     *  @Date: 2020-10-20 16:01
     *  @version: V1.0
     *  @Description:
     */
    void delByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode);

    /**
     * 查询范围对应的政策id列表（客户、组织）
     * @param
     * @return
     */
    Set<String> selectPromotionPolicyIdByScopeCode(String custCode, Set<String> orgCodes);

    /**
     * 查询范围对应的政策id列表（终端）
     * @param terminalCode 终端编码
     * @param orgCodes
     * @return
     */
    Set<String> selectPromotionPolicyIdByTerminal(String terminalCode, Set<String> orgCodes);

    /**
     * 计算给定政策下相关的客户编码
     * @param promotionPolicyIds
     * @return
     */
    List<String> countCustCodesByPromotionPolicyId(Set<String> promotionPolicyIds);

    /**
     * 根据账户查询可用促销政策（固定参数）
     * @param accountCodes   账户编码，可能是客户编码、终端编码等
     * @param orgCodes  组织编码，可能是客户组织编码、终端组织编码等
     * @param channelCodes 渠道编码，可能是客户渠道编码、终端渠道编码等
     * @param accountType 账户类型，{@link ScopeTypeDynamicEnum} && {@link AccountTypeDynamicEnum}
     * @param orgType 组织类型，{@link ScopeTypeDynamicEnum} && {@link AccountTypeDynamicEnum}
     * @param channelType 渠道类型，{@link ScopeTypeDynamicEnum} && {@link AccountTypeDynamicEnum}
     * @return
     */
    @Deprecated
    List<String> findPromotionCodesByAccounts(List<String> accountCodes, List<String> orgCodes,
                                              List<String> channelCodes, String accountType,
                                              String orgType, String channelType);

    /**
     * 根据账户查询可用促销政策（可变参数）
     * 功能与该方法相同：{@link PromotionPolicyScopeService#findPromotionCodesByAccounts(java.util.List, java.util.List, java.util.List, java.lang.String, java.lang.String, java.lang.String)}
     * @param unitCodeLists
     * @param unitTypes
     * @return
     */
    List<String> findPromotionCodesByAccounts(List<String>[] unitCodeLists, String... unitTypes);
}
