package com.biz.crm.promotion.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.promotion.*;
import com.biz.crm.nebular.dms.promotion.param.QueryProductPolicyParamVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.PromotionPolicyInfoDataVo;
import com.biz.crm.promotion.entity.PromotionPolicyEntity;
import com.biz.crm.promotion.entity.resp.PromotionPolicyPageResp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 *  @author: luoqi
 *  @Date: 2020-10-15 16:42
 *  @version: V1.0
 *  @Description:
 */
public interface PromotionPolicyService {

    /**
     * 新增和修改
     *  @author: luoqi
     *  @Date: 2020-10-20 15:34
     *  @version: V1.0
     *  @Description:
     */
    void addOrUpdate(PromotionPolicyEditReqVo vo);


    /**
     * 计算给定日期生效和失效政策影响到的客户列表
     * @param date
     * @param promotionIds
     */
    List<String> countBeginAndEndAffectedCustoms(String date, List<String> promotionIds);

    /**
     * 查询给定的客户在给定的商品下能够享受的促销政策
     *  @author: luoqi
     *  @Date: 2020-10-21 11:20
     *  @version: V1.0
     *  @Description:
     */
    List<PromotionPolicyInfoDataVo> loadPromotionPolicyInfoByCustAndProduct(String custCode, String productCode);

    /**
     * 查询给定的客户在给定的商品列表下能够享受的促销政策
     *  @author: luoqi
     *  @Date: 2020-10-21 11:20
     *  @version: V1.0
     *  @Description:
     */
    Map<String, List<PromotionPolicyInfoVo>> loadPromotionPolicyInfoByCustAndProducts(String custCode, List<String> productCodes);

    /**
     *给定的客户在给定的商品列表下是否能享受促销政策
     * @param custCode
     * @param productCodes
     * @return
     */
    Map<String, Boolean> custProductsHasPromotionPolicy(String custCode, List<String> productCodes);

    /**
     * 加载政策编辑页面数据
     *  @author: luoqi
     *  @Date: 2020-10-20 17:07
     *  @version: V1.0
     *  @Description:
     */
    PromotionPolicyEditVo loadPolicyEditVo(String id, String templateId);

    /**
     * 分页
     *  @author: luoqi
     *  @Date: 2020-10-20 15:34
     *  @version: V1.0
     *  @Description:
     */
    PageResult<PromotionPolicyPageResp> getPageList(PromotionPolicyQueryVo vo);

    /**
     * 查询模板下的政策
     *  @author: luoqi
     *  @Date: 2020-10-16 11:20
     *  @version: V1.0
     *  @Description:
     */
    List<PromotionPolicyEntity> getListByTemplate(String templateId, String templateCode);


    /**
     * 删除
     *  @author: luoqi
     *  @Date: 2020-10-16 15:46
     *  @version: V1.0
     *  @Description:
     */
    void del(List<String> promotionPolicyIds);

    /**
     * 启用
     *  @author: luoqi
     *  @Date: 2020-10-16 15:46
     *  @version: V1.0
     *  @Description:
     */
    void enable(List<String> promotionPolicyIds);

    /**
     * 禁用
     *  @author: luoqi
     *  @Date: 2020-10-16 15:46
     *  @version: V1.0
     *  @Description:
     */
    void disable(List<String> promotionPolicyIds);

    /**
     * 加载订单下所有商品享受的促销政策和政策规则配置信息
     * 筛选促销范围、起订量、可用余量
     * 特别注意：因为丰谷线上已使用该方法，请不要随意改动，如果需要改动，请重载该方法
     */
    @Deprecated
    Map<String, List<PromotionPolicyConfigInfo>> loadPromotionPolicyConfigInfoForOrder(PromotionPolicyConfigInfoQueryVo configInfoQueryVo);

    /**
     * 加载商品享受的促销政策和政策规则配置信息
     * 只筛选促销范围
     * 特别注意：因为丰谷线上已使用该方法，请不要随意改动，如果需要改动，请重载该方法
     * @param productPolicyParamVo
     * @return
     */
    @Deprecated
    List<PromotionPolicyConfigInfo> loadPromotionPolicyConfigInfoByProductCode(QueryProductPolicyParamVo productPolicyParamVo);

    /**
     * 根据id查询政策对象
     * @param promotionPolicyId
     * @return
     */
    PromotionPolicyVo findById(String promotionPolicyId);
    /**
     * 根据id查询政策对象
     * @param promotionPolicyIds
     * @return
     */
    List<PromotionPolicyVo> findByIds(ArrayList<String> promotionPolicyIds);

    /**
     * 查询促销vo（订单专用）
     * @param promotionPolicyForOrderReqVo
     * @return key：productCode+promotionCode中间用英文半角逗号隔开
     */
//    Map<String,PromotionPolicyConfigInfo> searchPromotionToOrder(PromotionPolicyForOrderReqVo promotionPolicyForOrderReqVo);

    /**
     * 加载订单下所有商品享受的促销政策和政策规则配置信息
     * 筛选促销范围，促销范围、起订量、可用余量
     * 特别注意：因为丰谷线上已使用该方法，请不要随意改动，如果需要改动，请重载该方法
     */
    Map<String, List<PromotionPolicyConfigInfo>> loadPromotionPolicyConfigInfoForSelect(PromotionPolicyConfigInfoQueryVo configInfoQueryVo);

    /**
     * 根据客户查询所有可用促销（商品编码作为key）
     * @param cusCode
     * @return
     */
    Map<String, List<PromotionPolicyConfigInfo>> findProductMapByCusCode(String cusCode);

    /**
     * 根据编码查询政策（带出模板）
     * @param promotionPolicyCode
     * @return
     */
    PromotionPolicyVo findByCode(String promotionPolicyCode);

}
