package com.biz.crm.promotion.service.component;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyRuleVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.nebular.dms.promotion.policy.resp.PromotionPolicyInfoDataVo;
import com.biz.crm.promotion.entity.DmsPromotionPolicyOrderDetailEntity;
import com.biz.crm.promotion.service.IDmsPromotionPolicyOrderDetailService;
import com.biz.crm.promotion.service.PromotionPolicyService;
import com.biz.crm.promotion.service.component.function.RuleFunction;
import com.biz.crm.promotion.service.component.function.param.CalculateRuleParam;
import com.biz.crm.promotion.service.component.function.param.LimitedRuleParam;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import static com.biz.crm.eunm.YesNoEnum.YesNoCodeNumberEnum.YES;


/**
 * 默认政策业务规则执行实现
 *  @author: luoqi
 *  @Date: 2020-11-20 15:23
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component("defaultRuleExecutor")
public class DefaultRuleExecutor implements RuleExecutor<CalculateRuleResponse> {

    @Resource
    private PromotionPolicyService promotionPolicyService;
    @Resource
    private IDmsPromotionPolicyOrderDetailService iDmsPromotionPolicyOrderDetailService;
    @Resource
    private ProductPriceMatcher productPriceMatcher;
    @Value("${promotion.rounding:1}")
    private Integer rounding;

    @Override
    public CalculateRuleResponse execute(RuleExecuteParam ruleExecuteParam) {
        this.checkParam(ruleExecuteParam);
        PromotionPolicyConfigInfo promotionPolicyConfigInfo = ruleExecuteParam.getPromotionPolicyConfigInfo();
        ValidateUtils.validate(promotionPolicyConfigInfo, "促销政策详情不能为空");
        //政策条件规则
        PromotionPolicyRuleVo condition = promotionPolicyConfigInfo.getCondition();
        //政策计算规则
        PromotionPolicyRuleVo calculate = promotionPolicyConfigInfo.getCalculate();

//        shellParam.setCustCode();
//        shellParam.setFirstOrder();
//        shellParam.setProductCode();
        //计算规则
        RuleFunction<CalculateRuleParam, CalculateRuleResponse> ruleFunction;
        try {
            ruleFunction = SpringApplicationContextUtil
                    .getApplicationContext().getBean(calculate.getFuncBody(), RuleFunction.class);
        }catch (BeansException e){
            throw new BusinessException("促销政策计算规则[" + calculate.getRuleCode() + "]计算失败, 未查找到该规则的计算实例", e);
        }
        //组装计算规则参数
        CalculateRuleParam calculateRuleParam = new CalculateRuleParam();
        //阶梯列表
        calculateRuleParam.setLadderList(JsonPropertyUtil.toArray(condition.getParams(), PromotionRuleEditVo.ControlRow.class));
        List<RuleExecuteParam.ProductOrderBuy> productOrderBuy = ruleExecuteParam.getProductOrderBuy();
        //订单内的商品购买明细
        calculateRuleParam.setProductOrderBuy(productOrderBuy);
        //阶梯计算所使用的条件规则
        calculateRuleParam.setConditionRuleFunctionBeanName(condition.getFuncBody());
        //计算并设置政策可用余额和价格
        this.computePromotionVariable(condition.getPromotionPolicyId(), ruleExecuteParam, calculateRuleParam);

        //执行计算规则
        CalculateRuleResponse calculateRuleResponse = ruleFunction.apply(calculateRuleParam);
        BigDecimal resultData = calculateRuleResponse.getResultData();
        if(YES.getCode().equals(rounding)
                && CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.NUMBER.getItemCode().equals(calculateRuleResponse.getResultDataType())
                && resultData != null) {
            resultData = resultData.setScale(0, BigDecimal.ROUND_DOWN);
        }
        calculateRuleResponse.setResultData(resultData);
        //向子类暴露对计算结果的扩展
        calculateRuleResponse = this.calculateRuleExecuted(ruleExecuteParam, calculateRuleResponse);
        if(null == calculateRuleResponse){
            throw new BusinessException("计算规则结果扩展处理失败，请重试。");
        }
        //限量规则执行
        //TODO 暂时先取消到限量规则校验
//        this.doLimited(ruleExecuteParam, calculateRuleResponse);
        return calculateRuleResponse;
    }

    /**
     * 计算政策可用余额
     * @param promotionPolicyId
     * @param ruleExecuteParam
     * @param calculateRuleParam
     * @return
     */
    private void computePromotionVariable(String promotionPolicyId, RuleExecuteParam ruleExecuteParam, CalculateRuleParam calculateRuleParam) {
        ProductPriceMatcher.PriceMatchParam priceMatchParam = new ProductPriceMatcher.PriceMatchParam();
        PromotionPolicyConfigInfo promotionPolicyConfigInfo = ruleExecuteParam.getPromotionPolicyConfigInfo();
        ValidateUtils.validate(promotionPolicyConfigInfo, "政策详情不能为空");
        PromotionPolicyInfoDataVo promotionPolicyInfoVo = promotionPolicyConfigInfo.getPromotionPolicyInfoVo();
        ValidateUtils.validate(promotionPolicyInfoVo, "促销政策不能为空");
        priceMatchParam.setChanelCode(promotionPolicyInfoVo.getChanel());
        priceMatchParam.setSaleCompanyCode(promotionPolicyInfoVo.getSaleCompanyCode());
        priceMatchParam.setCusCode(ruleExecuteParam.getCusCode());
        priceMatchParam.setCusTypeCode(ruleExecuteParam.getCusTypeCode());
        priceMatchParam.setCusOrgCode(ruleExecuteParam.getCusOrgCode());
        if(CollectionUtil.listEmpty(promotionPolicyConfigInfo.getProductsGift())) {
            return;
        }
//        ValidateUtils.notEmpty(promotionPolicyConfigInfo.getProductsGift(), "促销政策【%s】没有赠品，请检查该政策数据", promotionPolicyInfoVo.getPromotionPolicyCode());
        Map<String, BigDecimal> prices;
        if(CollectionUtil.mapNotEmpty(ruleExecuteParam.getPrices())) {
            prices = ruleExecuteParam.getPrices();
        } else {
            prices = Maps.newHashMap();
            promotionPolicyConfigInfo.getProductsGift().forEach(product -> {
                priceMatchParam.setProductCode(product.getProductCode());
                BigDecimal price = productPriceMatcher.priceMatch(priceMatchParam);
                ValidateUtils.validate(price, "获取价格异常，入参：渠道-%s，销售公式-%s，商品-%s", priceMatchParam.getChanelCode(), priceMatchParam.getSaleCompanyCode(), priceMatchParam.getProductCode());
                prices.put(product.getProductCode(), price);
            });
        }

        calculateRuleParam.setPrices(prices);
        if(StringUtils.isBlank(promotionPolicyId)) {
            return;
        }
        PromotionPolicyVo promotionPolicyVo = this.promotionPolicyService.findById(promotionPolicyId);
        if(promotionPolicyVo == null) {
            return;
        }
        List<DmsPromotionPolicyOrderDetailEntity> dmsPromotionPolicyOrderDetailRespVos =
                this.iDmsPromotionPolicyOrderDetailService.list(Wrappers.<DmsPromotionPolicyOrderDetailEntity>query()
                        .eq("promotion_policy_id", promotionPolicyId));
        if(CollectionUtil.listEmpty(dmsPromotionPolicyOrderDetailRespVos)) {
            calculateRuleParam.setVariable(promotionPolicyVo.getUsedQtyUpper());
            return;
        }
        BigDecimal useQtyUpper = promotionPolicyVo.getUsedQtyUpper();
        if(useQtyUpper == null) {
            return;
        }
        for(DmsPromotionPolicyOrderDetailEntity entity : dmsPromotionPolicyOrderDetailRespVos) {
            BigDecimal usedAmount;
            if(CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.NUMBER.getItemCode().equals(entity.getUsedQtyType())) {
                //TODO 暂时默认使用第一个价格
                usedAmount = prices.entrySet().iterator().next().getValue().multiply(entity.getUsedQty());
            } else {
                usedAmount = entity.getUsedQty();
            }
            useQtyUpper = useQtyUpper.subtract(usedAmount);
        }
        calculateRuleParam.setVariable(useQtyUpper);
    }

    /**
     * 限量规则脚本执行
     * @param ruleExecuteParam
     * @param calculateRuleResponse
     */
    protected void doLimited(RuleExecuteParam ruleExecuteParam, CalculateRuleResponse calculateRuleResponse){
        PromotionPolicyConfigInfo promotionPolicyConfigInfo = ruleExecuteParam.getPromotionPolicyConfigInfo();
        ValidateUtils.validate(promotionPolicyConfigInfo, "促销政策详情不能为空");
        //政策限量规则
        List<PromotionPolicyRuleVo> limited = promotionPolicyConfigInfo.getLimited();
        if(CollectionUtils.isEmpty(limited)){
            return;
        }
        LimitedRuleParam limitedRuleParam = new LimitedRuleParam();
        for(PromotionPolicyRuleVo ruleVo : limited){
            PromotionRuleEditVo.KeyValParamControl keyValParamControl = limitedKeyValParam(ruleVo.getParams());
            Object limitedConfigStr = keyValParamControl.getValue();
            if(!Objects.isNull(limitedConfigStr)){
                limitedRuleParam.setLimitedConfig(new BigDecimal(limitedConfigStr.toString()));
            }
            limitedRuleParam.setGift(calculateRuleResponse.getResultData());
            RuleFunction<LimitedRuleParam, BigDecimal> ruleFunction;
            try {
                ruleFunction = SpringApplicationContextUtil
                        .getApplicationContext().getBean(ruleVo.getFuncBody(), RuleFunction.class);
            }catch (BeansException e){
                throw new BusinessException("促销政策限量规则[" + ruleVo.getRuleCode() + "]计算失败, 未查找到该规则的计算实例", e);
            }

            BigDecimal result = ruleFunction.apply(limitedRuleParam);
            if(null == result){
                throw new BusinessException("促销政策限量规则[" + ruleVo.getRuleCode() + "]计算失败， 该规则未计算出可用的结果");
            }
            calculateRuleResponse.setResultData(result);
        }
    }

    /**
     * 解析限量规则配置的参数
     * @param paramStr
     * @return
     */
    protected PromotionRuleEditVo.KeyValParamControl limitedKeyValParam(String paramStr){
        if(StringUtils.isNotBlank(paramStr)){
            List<PromotionRuleEditVo.ControlRow> controlRows = JsonPropertyUtil.toArray(paramStr, PromotionRuleEditVo.ControlRow.class);
            if(!CollectionUtils.isEmpty(controlRows) && null != controlRows.get(0)){
                PromotionRuleEditVo.ControlRow controlRow = controlRows.get(0);
                if(!CollectionUtils.isEmpty(controlRow.getControls())){
                    return controlRow.getControls().get(0);
                }
            }
        }
        return new PromotionRuleEditVo.KeyValParamControl();
    }


    /**
     * 计算规则执行完成后，向子类暴露对计算结果的扩展
     * @param calculateRuleResponse
     * @return
     */
    protected CalculateRuleResponse calculateRuleExecuted(RuleExecuteParam ruleExecuteParam, CalculateRuleResponse calculateRuleResponse){
        return calculateRuleResponse;
    }

    /**
     * 校验参数
     * @param ruleExecuteParam
     */
    protected void checkParam(RuleExecuteParam ruleExecuteParam){
        if(null == ruleExecuteParam){
            throw new BusinessException("参数不能为空");
        }
        List<RuleExecuteParam.ProductOrderBuy> productOrderBuy = ruleExecuteParam.getProductOrderBuy();
        if(CollectionUtils.isEmpty(productOrderBuy)){
            throw new BusinessException("请指定需要计算的订单商品信息");
        }
        productOrderBuy.forEach(v -> {
            if(null == v.getProductBuyAmount()){
                throw new BusinessException("请指定商品[" + v.getProductCode() + "]的金额购买金额");
            }
            if(null == v.getProductBuyNo()){
                throw new BusinessException("请指定商品[" + v.getProductCode() + "]的数量购买数量");
            }
        });
        //促销政策详细信息
        PromotionPolicyConfigInfo promotionPolicyConfigInfo = ruleExecuteParam.getPromotionPolicyConfigInfo();
        ValidateUtils.validate(promotionPolicyConfigInfo, "促销政策详细信息不能为空");
        //政策条件规则
        PromotionPolicyRuleVo condition = promotionPolicyConfigInfo.getCondition();
        //政策计算规则
        PromotionPolicyRuleVo calculate = promotionPolicyConfigInfo.getCalculate();
        if(null == calculate){
            throw new BusinessException("请指定计算规则");
        }
        if(StringUtils.isBlank(condition.getRuleCode())){
            throw new BusinessException("计算规则编码不能为空");
        }
        if(StringUtils.isBlank(condition.getFuncBody())){
            throw new BusinessException("计算规则脚本体不能为空");
        }
        if(null == condition){
            throw new BusinessException("请指定条件规则");
        }
        if(StringUtils.isBlank(condition.getRuleCode())){
            throw new BusinessException("条件规则编码不能为空");
        }
        if(StringUtils.isBlank(condition.getFuncBody())){
            throw new BusinessException("条件规则脚本体不能为空");
        }
        if(StringUtils.isBlank(condition.getParams())){
            throw new BusinessException("条件规则阶梯配置数据不能为空");
        }
    }
}
