package com.biz.crm.promotion.service.component;

import lombok.Data;

import java.math.BigDecimal;


/**
 * 商品询价接口定义-给项目实现的
 *  @author: luoqi
 *  @Date: 2021-1-6 19:13
 *  @version: V1.0
 *  @Description:
 */
public interface ProductPriceMatcher {
    /**
     * 商品询价
     * @param param
     * @return
     */
    BigDecimal priceMatch(PriceMatchParam param);


    /**
     * 销售公司/渠道/产品        你那边只按照这个维度
     *   @author: luoqi
     *  @Date: 2021-1-6 19:10
     *  @version: V1.0
     *  @Description:
     */
    @Data
    class PriceMatchParam{
        /** 销售公司 */
        private String saleCompanyCode;
        /** 渠道 */
        private String chanelCode;
        /** 产品 */
        private String productCode;
        /** 客户编码 */
        private String cusCode;
        /** 销售区域 */
        private String cusOrgCode;
        /** 客户分类 */
        private String cusTypeCode;
    }
}
