package com.biz.crm.promotion.service.component;


import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfoQueryVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyRuleVo;
import java.util.Map;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 *
 * 促销政策详细信息
 *  @author: luoqi
 *  @Date: 2020-10-29 14:38
 *  @version: V1.0
 *  @Description:
 */
@Data
public class RuleExecuteParam {
    //促销政策详细信息
    private PromotionPolicyConfigInfo promotionPolicyConfigInfo;
    //本品购买量
    private List<ProductOrderBuy> productOrderBuy;
    //赠品价格，key：产品编码，value：价格
    private Map<String, BigDecimal> prices;
    /** 客户编码 */
    private String cusCode;
    /** 销售区域 */
    private String cusOrgCode;
    /** 客户分类 */
    private String cusTypeCode;

    /**
     * 本品购买量
     *  @author: luoqi
     *  @Date: 2020-11-26 10:41
     *  @version: V1.0
     *  @Description:
     */
    @Data
    public static class ProductOrderBuy{
        public ProductOrderBuy(){}
        public ProductOrderBuy(PromotionPolicyConfigInfoQueryVo.ProductOrderInfo productOrderInfo){
            this.productCode = productOrderInfo.getProductCode();
            this.productBuyAmount = productOrderInfo.getProductBuyAmount();
            this.productBuyNo = productOrderInfo.getProductBuyNo();
            this.unitConvertor = productOrderInfo.getUnitConvertor();
        }
        //本品商品编码
        private String productCode;
        //本品购买量-总金额
        private BigDecimal productBuyAmount;
        //本品购买量-总数量（基本单位）
        private BigDecimal productBuyNo;
        //本品购买总数量单位转换系数
        private BigDecimal unitConvertor;

    }

}
