package com.biz.crm.promotion.service.component.filter;

import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfoQueryVo;
import com.biz.crm.promotion.service.impl.LoadConfigInfoContext;
import com.biz.crm.util.CommonConstant;

import java.math.BigDecimal;
import java.util.Map;

public class PromotionPolicyUtils {
    private PromotionPolicyUtils(){}
    /**
     * 订单商品购买量
     *
     * @param qtyType
     * @param currentProductCode
     * @param context
     * @return
     */
    public static final BigDecimal getOrderQty(String qtyType, String currentProductCode, LoadConfigInfoContext context) {
        //订单购买的商品量明细
        Map<String, Map<String, BigDecimal>> productsOrderBuyMap = context.getProductsOrderBuyMap();
        //拿到该本品对应的订单商品明细
        Map<String, BigDecimal> productsOrderBuyInfo = productsOrderBuyMap.get(currentProductCode);
        BigDecimal orderQty = productsOrderBuyInfo.get(qtyType);//根据政策配置的组合起定量类型-qtyType，获取订单商品明细下的购买量（数量或者金额）
        //当为数量类型时，可能需要单位转换
        if (CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.NUMBER.getItemCode().equals(qtyType)) {
            //本品购买总数量单位转换系数
            BigDecimal unitConvertor = productsOrderBuyInfo.get(PromotionPolicyConfigInfoQueryVo.ProductOrderInfo.UNIT_CONVERTOR);
            //单位系数转换
            if (null != unitConvertor) {
                orderQty = orderQty.multiply(unitConvertor);
            }
        }
        return orderQty;
    }
}
