package com.biz.crm.promotion.service.component.filter.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.PromotionEnum;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfoQueryVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyInfoVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.PromotionPolicyInfoDataVo;
import com.biz.crm.promotion.entity.DmsPromotionPolicyOrderDetailEntity;
import com.biz.crm.promotion.service.IDmsPromotionPolicyOrderDetailService;
import com.biz.crm.promotion.service.component.filter.AbstractFilter;
import com.biz.crm.promotion.service.impl.LoadConfigInfoContext;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;


/**
 * 首单校验过滤
 *  @author: luoqi
 *  @Date: 2020-12-26 16:23
 *  @version: V1.0
 *  @Description:
 */
@Component("promotionPolicyFirstOrderFilter")
public class PromotionPolicyFirstOrderFilter extends AbstractFilter<PromotionPolicyInfoDataVo, LoadConfigInfoContext> {

    @Resource
    private IDmsPromotionPolicyOrderDetailService iDmsPromotionPolicyOrderDetailService;


    @Override
    public boolean filter(PromotionPolicyInfoDataVo promotionPolicyInfoVo, LoadConfigInfoContext context) {
        this.addHitDetail(promotionPolicyInfoVo, "FirstOrder", promotionPolicyInfoVo.getFirstOrder());
        //政策配置不需要控制首单
        if(YesNoEnum.yesNoEnum.NO.getValue().equals(promotionPolicyInfoVo.getFirstOrder())){
            return true;
        }
        PromotionPolicyConfigInfoQueryVo configInfoQueryVo = context.getConfigInfoQueryVo();
        if(null == configInfoQueryVo){
            return false;
        }
        String custCode = configInfoQueryVo.getCustCode();
        if(StringUtils.isBlank(custCode)){
            return false;
        }
        //查询促销政策消费明细记录
        List<DmsPromotionPolicyOrderDetailEntity> detailEntityList = this.iDmsPromotionPolicyOrderDetailService.list(Wrappers.lambdaQuery(DmsPromotionPolicyOrderDetailEntity.class)
                .eq(DmsPromotionPolicyOrderDetailEntity :: getCustomerCode, custCode)
                .in(DmsPromotionPolicyOrderDetailEntity :: getPolicyOrderDetailStatus
                        , Lists.newArrayList(PromotionEnum.POLICY_ORDER_DETAIL.commit.getVal(), PromotionEnum.POLICY_ORDER_DETAIL.locked.getVal())));
        this.addHitDetail(promotionPolicyInfoVo, "detailEntityList.size", String.valueOf(detailEntityList.size()));
        //没有消费明细，首单校验通过
        if(CollectionUtils.isEmpty(detailEntityList)){
            return true;
        }

        return false;
    }



}
