package com.biz.crm.promotion.service.component.filter.impl;

import com.biz.crm.nebular.dms.promotion.PromotionPolicyInfoVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.PromotionPolicyInfoDataVo;
import com.biz.crm.promotion.entity.PromotionPolicyProductEntity;
import com.biz.crm.promotion.service.component.filter.AbstractFilter;
import com.biz.crm.promotion.service.component.filter.PromotionPolicyUtils;
import com.biz.crm.promotion.service.impl.LoadConfigInfoContext;
import com.biz.crm.util.JsonPropertyUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Map;


/**
 * 单品起定量校验过滤
 *  @author: luoqi
 *  @Date: 2020-12-26 16:23
 *  @version: V1.0
 *  @Description:
 */
@Component("promotionPolicySingleProductFilter")
public class PromotionPolicySingleProductFilter extends AbstractFilter<PromotionPolicyInfoDataVo, LoadConfigInfoContext> {

    @Override
    public boolean filter(PromotionPolicyInfoDataVo promotionPolicyInfoVo, LoadConfigInfoContext context) {
        //政策本品列表映射
        Map<String, Map<String, PromotionPolicyProductEntity>> currentProductMap = context.getCurrentProductY();
        //该政策下配置的本品列表
        Map<String, PromotionPolicyProductEntity> currentProduct = currentProductMap.get(promotionPolicyInfoVo.getId());
        this.addHitDetail(promotionPolicyInfoVo, "currentProduct", String.valueOf(JsonPropertyUtil.toJsonString(currentProduct)));
        Map<String, Map<String, BigDecimal>> productsOrderBuyMap = context.getProductsOrderBuyMap();
        this.addHitDetail(promotionPolicyInfoVo, "productsOrderBuyMap", String.valueOf(JsonPropertyUtil.toJsonString(productsOrderBuyMap)));
        for (Map.Entry<String, PromotionPolicyProductEntity> entry : currentProduct.entrySet()) {
            PromotionPolicyProductEntity productEntity = entry.getValue();
            String qtyType = productEntity.getProductOrderQtyType();
            BigDecimal qty = productEntity.getProductOrderQty();
            if (StringUtils.isNotBlank(qtyType) && null != qty) {
                String currentProductCode = entry.getKey();//本品商品编码
                if (!productsOrderBuyMap.containsKey(currentProductCode)) {
                    return false;//订单下没有购买该本品，不能享受该政策
                }
                //该商品的购买量
                BigDecimal orderQty = PromotionPolicyUtils.getOrderQty(qtyType, currentProductCode, context);
                // 单品起定量不能满足
                if (null == orderQty || qty.compareTo(orderQty) > 0) {
                    return false;
                }
            }

        }

        return true;
    }


}
