package com.biz.crm.promotion.service.component.function;

import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.promotion.service.component.RuleExecuteParam;
import com.biz.crm.promotion.service.component.function.param.ConditionRuleParam;
import com.biz.crm.promotion.service.component.function.param.TestRuleParam;
import com.biz.crm.promotion.service.component.function.response.ConditionRuleResponse;
import com.biz.crm.promotion.service.component.resolver.ladder.AbstractConditionRuleLadderResolver;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.ValidateUtils;

import java.math.BigDecimal;
import java.util.List;


/**
 * 条件规则
 *  @author: luoqi
 *  @Date: 2020-11-26 20:50
 *  @version: V1.0
 *  @Description:
 */
public abstract class AbstractConditionRuleFunction<Param extends ConditionRuleParam, Resp extends ConditionRuleResponse> implements RuleFunction<Param, Resp> {

    /**
     * 返回订单购买数量对满赠数量取余结果，计算规则脚本可依据该结果进行灵活的阶梯计算
     * @param productBuyAmount 商品购买量
     * @param valueAsProductCurrentY 赠品赠送量
     * @return
     */
    protected Resp divideAndRemainder(BigDecimal productBuyAmount, BigDecimal valueAsProductCurrentY){
        BigDecimal[] temp = productBuyAmount.divideAndRemainder(valueAsProductCurrentY) ;
        Resp response = (Resp) new ConditionRuleResponse();
        //被整除的结果
        response.setDivide(temp[0]);
        //未被整除余下的结果
        response.setRemainder(temp[1]);
        return response;
    }

    /**
     * 测试规则
     * 测试 testParam
     * {"bizParam":{"productOrderBuy":[{"productBuyNo":20,"productBuyAmount":1000,"unitConvertor":10}]},"controlRow":{"text":"本单中本品数量购买满","controlKey":"control_key","controls":[{"key":"buyNo","value":10,"label":null,"labelPostfix":null,"description":"请输入本品数量","controlType":"input","selectOptions":[]},{"key":"buyUnit","value":"product_base_unit","label":null,"labelPostfix":null,"description":"请选择单位","controlType":"select","selectOptions":[{"key":"product_base_unit","value":"基本单位"},{"key":"material_sale_unit","value":"销售单位"}]},{"key":"giftNo","value":55,"label":"，送赠品","labelPostfix":null,"description":"请输入赠品数量","controlType":"input","selectOptions":[]},{"key":"buyUnit","value":"product_base_unit","label":null,"labelPostfix":null,"description":"请选择单位","controlType":"select","selectOptions":[{"key":"product_base_unit","value":"基本单位"},{"key":"material_sale_unit","value":"销售单位"}]}]}}
     * @param ruleParam
     * @return
     */
    @Override
    public Resp test(TestRuleParam ruleParam) {
        Param conditionRuleParam = (Param) new ConditionRuleParam();
        PromotionRuleEditVo.TestParam testParam = ruleParam.getTestParam();
        ValidateUtils.validate(testParam,"测试参数不能为空!");
        ValidateUtils.validate(testParam.getBizParam(),"测试参数[BizParam<k-v 业务参数对象>]不能为空!");
        String productOrderBuyStr = JsonPropertyUtil.toJsonString(testParam.getBizParam().get("productOrderBuy"));
        ValidateUtils.validate(productOrderBuyStr,"测试参数[BizParam.productOrderBuy<订单商品购买量列表>]不能为空!");
        List<RuleExecuteParam.ProductOrderBuy> productOrderBuy = JsonPropertyUtil.toArray(productOrderBuyStr, RuleExecuteParam.ProductOrderBuy.class);
        conditionRuleParam.setProductOrderBuy(productOrderBuy);
        conditionRuleParam.setLadder(testParam.getControlRow());
        conditionRuleParam.setRuleCode(ruleParam.getRuleCode());
        return this.apply(conditionRuleParam);
    }



}
