package com.biz.crm.promotion.service.component.function;

import com.biz.crm.promotion.service.component.function.param.RuleParam;
import com.biz.crm.promotion.service.component.function.param.TestRuleParam;
import com.biz.crm.promotion.service.component.resolver.ladder.AbstractConditionRuleLadderResolver;
import com.biz.crm.util.CommonConstant;


/**
 * 规则函数
 *  @author: luoqi
 *  @Date: 2020-11-26 20:38
 *  @version: V1.0
 *  @Description: Param:执行参数，Resp: 响应结果
 */
public interface RuleFunction<Param extends RuleParam, Resp> {
    /**
     * 执行规则
     * @param p
     * @return
     */
    Resp apply(Param p);

    /**
     * 测试规则
     * @param testRuleParam
     * @return
     */
    Resp test(TestRuleParam testRuleParam);

    /**
     * 获取条件数据类型(条件规则需要重写)
     * @return
     */
    default String getConditionType() {
        return CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.NUMBER.getItemCode();
    }
}
