package com.biz.crm.promotion.service.component.function.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.promotion.service.component.function.AbstractLimitedRuleFunction;
import com.biz.crm.promotion.service.component.function.param.LimitedRuleParam;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;


/**
 * 限量规则-每客每单
 *  @author: luoqi
 *  @Date: 2020-11-26 20:50
 *  @version: V1.0
 *  @Description:
 */
@Component("limitedOneCustOneOrder")
public class LimitedOneCustOneOrder extends AbstractLimitedRuleFunction<LimitedRuleParam> {
    @Override
    public BigDecimal apply(LimitedRuleParam limitedRuleParam) {

        if(null == limitedRuleParam.getLimitedConfig()){
            throw new BusinessException("促销政策限量规则[" + limitedRuleParam.getRuleCode() + "]计算失败, 缺少限量配置");
        }
        if(limitedRuleParam.getGift().compareTo(limitedRuleParam.getLimitedConfig()) > 0 ){
            return limitedRuleParam.getLimitedConfig();
        }
        return limitedRuleParam.getGift();
    }
}
