package com.biz.crm.promotion.service.component.function.impl.fullgift;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.promotion.service.component.function.AbstractCalculateRuleFunction;
import com.biz.crm.promotion.service.component.function.RuleFunction;
import com.biz.crm.promotion.service.component.function.param.CalculateRuleParam;
import com.biz.crm.promotion.service.component.function.param.ConditionRuleParam;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.promotion.service.component.function.response.ConditionRuleResponse;
import com.biz.crm.util.CommonConstant;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

import static com.biz.crm.eunm.YesNoEnum.YesNoCodeNumberEnum.YES;


/**
 * 计算规则-满赠
 *  @author: luoqi
 *  @Date: 2020-11-26 20:51
 *  @version: V1.0
 *  @Description:
 */
@Component("calculateGift")
public class CalculateGift extends AbstractCalculateRuleFunction<CalculateRuleParam, CalculateRuleResponse> {

    @Value("${promotion.rounding:1}")
    private Integer rounding;
    /**
     * 执行规则
     *
     * @param calculateRuleParam
     * @return
     */
    @Override
    public CalculateRuleResponse apply(CalculateRuleParam calculateRuleParam) {
        //条件规则
        RuleFunction<ConditionRuleParam, ConditionRuleResponse> ruleFunction;
        try {
            ruleFunction = SpringApplicationContextUtil
                    .getApplicationContext().getBean(calculateRuleParam.getConditionRuleFunctionBeanName(), RuleFunction.class);
        }catch (BeansException e){
            throw new BusinessException("促销政策条件规则[" + calculateRuleParam.getConditionRuleFunctionBeanName() + "]计算失败, 未查找到该规则的计算实例", e);
        }
        //结果类型
        String resultDataType = null, resultDataUnitType = null;
        BigDecimal result = null;
        /**
         * 用户配置的阶梯列表
         * 倒序迭代阶梯列表，因为阶梯的顺序是从小到大的，默认由最大阶梯开始计算
         */
        List<PromotionRuleEditVo.ControlRow> ladderList = calculateRuleParam.getLadderList();
        PromotionRuleEditVo.ControlRow tempLadder = null;
        String msg = new String();
        BigDecimal price;
        for(int i = ladderList.size() - 1; i >= 0; i--){
            //阶梯
            tempLadder = ladderList.get(i);
            //组装条件规则计算所需参数
            ConditionRuleParam conditionRuleParam = new ConditionRuleParam();
            conditionRuleParam.setLadder(tempLadder);
            conditionRuleParam.setProductOrderBuy(calculateRuleParam.getProductOrderBuy());
            //条件规则计算
            ConditionRuleResponse conditionRuleResponse = ruleFunction.apply(conditionRuleParam);

            /**
             * 普通满赠计算规则：按最大阶梯计算
             */
            if(conditionRuleResponse.getDivide().compareTo(BigDecimal.ZERO) > 0){
                //当前阶梯计算出来的赠送量
                BigDecimal computeResult = conditionRuleResponse.getGiftValue() == null ? BigDecimal.ZERO : conditionRuleResponse.getGiftValue();
                //如果计算数据类型是数量，则换算成金额再做比较
                BigDecimal compareResult;
                if(CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.NUMBER.getItemCode().equals(conditionRuleResponse.getResultDataType())) {
                    //TODO 同一个政策暂时只支持一个赠品
                    compareResult = computeResult.multiply(calculateRuleParam.getPrices().entrySet().iterator().next().getValue());
                } else {
                    compareResult = computeResult;
                }

                //结果类型
                resultDataType = conditionRuleResponse.getResultDataType();
                //单位类型
                resultDataUnitType = conditionRuleResponse.getResultDataUnitType();
                //如果余量充足则返回计算结果
                if(calculateRuleParam.getVariable() == null || calculateRuleParam.getVariable().compareTo(compareResult) > -1) {
                    msg = msg.concat("匹配到的阶梯是:".concat(tempLadder.getControlKey()));
                    result = computeResult;
                    break;
                }
                msg = msg.concat("因为政策余量不足，所以跳过该阶梯:".concat(tempLadder.getControlKey()).concat("阶梯，"));
            }
        }
        CalculateRuleResponse calculateRuleResponse = new CalculateRuleResponse();
        //未匹配到合适的促销政策阶梯
        if(null == result || YES.getCode().equals(rounding) && result.compareTo(BigDecimal.ONE)<0){
            //如果当前政策有阶梯，则会产生匹配阶梯的结果信息
            calculateRuleResponse.setNoLadderMatchMsg("购买量还没有达到政策阶梯起送量，或者赠送数量小于1");
            if(StringUtils.isNotBlank(msg)) {
                calculateRuleResponse.setNoLadderMatchMsg(msg);
            }
            calculateRuleResponse.setLadderUsed(Lists.newArrayList());
            return calculateRuleResponse;
        }
        if(StringUtils.isNotBlank(msg)) {
            calculateRuleResponse.setNoLadderMatchMsg(msg);
        }

        if(CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.NUMBER.getItemCode().equals(resultDataType)) {
            result = result == null ? result : result.setScale( 0, BigDecimal.ROUND_DOWN );
        }
        //计算结果
        calculateRuleResponse.setResultData(result);
        //计算结果类型 QTY_TYPE number:数量； amount:金额
        calculateRuleResponse.setResultDataType(resultDataType);
        //计算结果单位类型 数据字典：unit_type 枚举类：ProductUnitEnum
        calculateRuleResponse.setResultDataUnitType(resultDataUnitType);
        //命中的阶梯
        calculateRuleResponse.setLadderUsed(Lists.newArrayList(tempLadder));
        return calculateRuleResponse;
    }






}
