package com.biz.crm.promotion.service.component.function.impl.fullgift;

import com.biz.crm.promotion.service.component.RuleExecuteParam;
import com.biz.crm.promotion.service.component.function.AbstractConditionRuleFunction;
import com.biz.crm.promotion.service.component.function.param.ConditionRuleParam;
import com.biz.crm.promotion.service.component.function.response.ConditionRuleResponse;
import com.biz.crm.promotion.service.component.resolver.ladder.AbstractConditionRuleLadderResolver;
import com.biz.crm.promotion.service.component.resolver.ladder.LadderResolverHelper;
import com.biz.crm.util.CommonConstant;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;


/**
 * 条件规则-金额~数量
 *  @author: luoqi
 *  @Date: 2020-11-26 20:50
 *  @version: V1.0
 *  @Description:
 */
@Component(ConditionAmountNo.FUNC_BODY)
public class ConditionAmountNo extends AbstractConditionRuleFunction<ConditionRuleParam, ConditionRuleResponse> {
    public static final String FUNC_BODY = "conditionAmountNo";
    @Resource
    private LadderResolverHelper ladderResolverHelper;


    @Override
    public ConditionRuleResponse apply(ConditionRuleParam conditionRuleParam) {
        //获取该规则的阶梯解析器
        AbstractConditionRuleLadderResolver ladderResolver = ladderResolverHelper.getResolverByFuncBody(FUNC_BODY);
        //订单内的商品购买明细
        List<RuleExecuteParam.ProductOrderBuy> productOrderBuy = conditionRuleParam.getProductOrderBuy();
        //总数量
//        BigDecimal productBuyNo = BigDecimal.ZERO;
        //总金额
        BigDecimal productBuyAmount = BigDecimal.ZERO;
        //汇总商品的总购买量
        if(null != productOrderBuy){
            for(RuleExecuteParam.ProductOrderBuy v : productOrderBuy){
                productBuyAmount = productBuyAmount.add(v.getProductBuyAmount());
            }
        }
        /**
         * 返回订单购买数量对满赠数量取余结果，计算规则脚本可依据该结果进行灵活的阶梯计算
         */
        ConditionRuleResponse response = this.divideAndRemainder(productBuyAmount, ladderResolver.valueAsProductCurrentY(conditionRuleParam.getLadder()));
        //阶梯赠品赠送量数据类型
        response.setResultDataType(CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.NUMBER.getItemCode());
        //阶梯赠品单位配置
        String unitType = ladderResolver.unitAsProductCurrentN(conditionRuleParam.getLadder());
        response.setResultDataUnitType(unitType);
        //阶梯赠品赠送量配置
        response.setGiftValue(ladderResolver.valueAsProductCurrentN(conditionRuleParam.getLadder()));
        return response;
    }

    @Override
    public String getConditionType() {
        return CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.AMOUNT.getItemCode();
    }


}
